<?php

require_once("includes/db2.php"); // Ensure this establishes your database connection

// Start session
session_start();

// Ensure the `certi_no` is passed as a query parameter
if (isset($_GET['no']) && !empty($_GET['no'])) {
    $certi_no = trim($_GET['no']); // Sanitize input

    if ($conn) { // Ensure database connection is successful
        // Sanitize input for use in SQL query to prevent SQL injection
        $certi_no = mysqli_real_escape_string($conn, $certi_no);

        // Prepare the SQL query
        $query = "SELECT * FROM tbl_submission WHERE certi_no = '$certi_no'";

        // Execute the query
        $result = mysqli_query($conn, $query);

        if ($result) {
            if (mysqli_num_rows($result) > 0) {
                $data = mysqli_fetch_assoc($result);
                // You can now use $data to access the fetched row
            } else {
                die("No data found for this certificate number.");
            }
        } else {
            die("Query execution error: " . mysqli_error($conn));
        }
    } else {
        die("Database connection failed.");
    }
} else {
    die("Invalid certificate number.");
}
?>


<!DOCTYPE html>
<html webcrx="">

<head>
   <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
   <title><?php echo $data['name']; ?></title>
   <style type="text/css">
      body {
         background-color: lightgray;
         text-align: center;
      }

      .qoppa_pageborder {
         fill: white
      }

      #qoppa_document {
         margin: auto;
      }
   </style>
   <style type="text/css" media="print">
      @page {
         margin: 0 !important;
         size: A4 !important;
         color-adjust: exact !important;birt
         -webkit-print-color-adjust: exact !important;
         print-color-adjust: exact !important;
         background-color: #fff !important;
      }

      @media print {

         html,
         body {
            width: 210mm !important;
            height: 297mm !important;
            background-color: #fff !important;
         }

         .print {
            display: none !important;
         }
      }
   </style>
   <link href="https://fonts.maateen.me/kalpurush/font.css" rel="stylesheet">
   <link rel="stylesheet" href="nstyle.css?v=1">

</head>

<body>
   <button class="print" onclick="window.print()" style="position: absolute;z-index: 9999;background: green;left: 0;padding: 8px;width: -webkit-fill-available;border: 1px solid #fff;cursor: pointer;box-shadow: 0 4px 4px #878787;color: #fff;font-size: 16px;/* top: 0; */">Print Now</button>

   <!-- <g id="qoppa_viewxform" transform="matrix(1 0 0 1 0 0)"> -->

   <?php $let = $data['total_dose'];
   if ($let == 3) {
      include('brta.php');
   } else {

      include('svg.php');
   }

   ?>
   <!-- </g> -->

   <br>

   <!--?xml version='1.0' encoding='UTF-8'?-->
   <svg id="qoppa_document" width="1078px" height="841pt" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
      <style>
         title p {
            display: block;
         }
      </style>
      <g id="qoppa_viewxform" transform="matrix(1 0 0 1 0 0)">
         <style type="text/css">
            @font-face {
               font-family: f0-0;
               src: url("data:application/font-woff;charset=utf-8;base64,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");
            }
         </style><svg id="qoppa_page_p0" class="qoppa_page" y="0pt" width="1078px" height="841pt">
            <rect class="qoppa_pageborder" x="0.5pt" y="0.5pt" width="1078px" height="840pt" fill="none"></rect><svg class="qoppa_pagecontents" x="0pt" y="0pt" width="1078px" height="1160pt" viewBox="0 0 595 841">
               <g class="qoppa_contentstream" transform="matrix(1 0 0 -1 0 841.89)" fill="black" stroke="black" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10">
                  <clippath id="clip0-1">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-1)" fill="#008000" stroke="none" d="M 119.89 593.985 L 204.64 593.985 L 204.64 572.385 L 119.89 572.385 z "></path>
                  <path clip-path="url(#clip0-1)" fill="#008000" stroke="none" d="M 206.14 593.985 L 290.89 593.985 L 290.89 572.385 L 206.14 572.385 z "></path>
                  <path clip-path="url(#clip0-1)" fill="#008000" stroke="none" d="M 119.89 570.885 L 204.64 570.885 L 204.64 560.085 L 119.89 560.085 z "></path>
                  <path clip-path="url(#clip0-1)" fill="#008000" stroke="none" d="M 206.14 570.885 L 290.89 570.885 L 290.89 560.085 L 206.14 560.085 z "></path>
                  <path clip-path="url(#clip0-1)" fill="#008000" stroke="none" d="M 119.89 722.785 L 290.89 722.785 L 290.89 678.085 L 119.89 678.085 z "></path>
                  <path clip-path="url(#clip0-1)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 292.765 793.911 L 292.765 511.06 "></path>
                  <g clip-path="url(#clip0-1)">
                     <g transform="matrix(0.1003 0 0 -0.1003 190.39 792.785)">
                        <image xlink:href="data:image/png;base64,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" width="299" height="300" id="img57-0-2"></image>
                     </g>
                  </g>
                  <g clip-path="url(#clip0-1)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 125.9922 750.5249)" x="0 0.778 1.334 1.834 2.39 2.723 3.279 4.112 4.668 5.224 5.502 5.78 6.336 6.614 6.892 7.17 7.726 8.282 8.56 9.227 9.783 10.339 10.895 11.117 11.673 11.864 12.364 12.642 13.364 13.92 14.476 15.032 15.588 15.81 16.032 16.532 16.81 17.366">Government of the People's Republic of</text></g>
                  <g clip-path="url(#clip0-1)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 181.6212 739.7249)" x="0 0.667 1.223 1.779 2.335 2.557 3.113 3.669 4.225 4.725">Bangladesh</text></g>
                  <g clip-path="url(#clip0-1)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 130.6182 728.9249)" x="0 0.833 1.055 1.611 1.833 2.333 2.611 2.944 3.444 3.722 4.278 4.556 4.834 5.556 6.112 6.668 6.89 7.168 7.724 8.002 8.558 9.114 9.67 9.948 10.559 11.115 11.948 12.17 12.392 12.892 13.17 14.114 14.67 14.892 15.17 15.726 16.059">Ministry of Health and Family Welfare</text></g>
                  <path clip-path="url(#clip0-1)" fill="none" stroke="#ddd" stroke-width="0.75" stroke-linecap="square" d="M 120.265 722.41 L 120.265 678.46 "></path>
                  <path clip-path="url(#clip0-1)" fill="none" stroke="#ddd" stroke-width="0.75" stroke-linecap="square" d="M 120.265 722.41 L 290.515 722.41 "></path>
                  <path clip-path="url(#clip0-1)" fill="none" stroke="#ddd" stroke-width="0.75" stroke-linecap="square" d="M 290.515 722.41 L 290.515 678.46 "></path>
                  <path clip-path="url(#clip0-1)" fill="none" stroke="#ddd" stroke-width="0.75" stroke-linecap="square" d="M 120.265 678.46 L 290.515 678.46 "></path>
                  <g clip-path="url(#clip0-1)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 177.7178 710.8208)" x="0">C</text></g>
                  <clippath id="clip0-3">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-3)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 182.2881 719.7153 C 181.0971 719.7153 180.1731 719.3503 179.5171 718.6193 C 178.7001 717.7333 178.2921 716.5573 178.2921 715.0923 C 178.2921 713.6113 178.7161 712.4363 179.5631 711.5653 C 180.2201 710.8853 181.1121 710.5453 182.2411 710.5453 C 184.3781 710.5453 185.5771 711.7013 185.8391 714.0143 L 184.6901 714.0143 C 184.6011 713.4443 184.4681 712.9903 184.2921 712.6543 C 184.2611 712.5843 184.2221 712.5183 184.1751 712.4553 C 183.7651 711.8383 183.1241 711.5293 182.2531 711.5293 C 181.5891 711.5293 181.0201 711.7253 180.5481 712.1153 C 179.7901 712.7483 179.4111 713.7443 179.4111 715.1043 C 179.4111 716.0023 179.5711 716.7503 179.8921 717.3483 C 180.3801 718.2703 181.1361 718.7313 182.1591 718.7313 C 182.9331 718.7153 183.5091 718.5293 183.8881 718.1743 C 184.1881 717.8973 184.3991 717.4573 184.5201 716.8563 L 185.6631 716.8563 C 185.3191 718.7623 184.1941 719.7153 182.2881 719.7153 z "></path>
                  <clippath id="clip0-4">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-4)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 186.3818 710.8208)" x="0">O</text></g>
                  <clippath id="clip0-5">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-5)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 188.1689 718.6196 C 187.2819 717.7646 186.8389 716.5996 186.8389 715.1276 C 186.8389 713.8426 187.1869 712.7836 187.8819 711.9516 C 188.6669 711.0146 189.7279 710.5456 191.0639 710.5456 C 192.1419 710.5456 193.0459 710.8536 193.7759 711.4716 C 193.9679 711.6316 194.1439 711.8146 194.3039 712.0216 C 194.9599 712.8616 195.2879 713.8736 195.2879 715.0566 C 195.2879 715.3466 195.2709 715.6216 195.2349 715.8836 C 195.1179 716.7976 194.8189 717.5706 194.3389 718.2036 L 194.3149 718.2266 L 194.3039 718.2386 C 193.5259 719.2236 192.4419 719.7156 191.0519 719.7156 C 189.8919 719.7156 188.9309 719.3496 188.1689 718.6196 z M 192.9909 718.0576 C 193.7759 717.3926 194.1689 716.4006 194.1689 715.0806 C 194.1689 714.1356 193.9369 713.3516 193.4719 712.7306 C 192.8979 711.9306 192.0949 711.5296 191.0639 711.5296 C 190.2859 711.5296 189.6299 711.7656 189.0949 712.2386 C 188.3329 712.9026 187.9519 713.8656 187.9519 715.1276 C 187.9519 716.0806 188.1769 716.8736 188.6259 717.5066 C 189.1999 718.3226 190.0089 718.7306 191.0519 718.7306 C 191.8169 718.7306 192.4639 718.5066 192.9909 718.0576 z "></path>
                  <clippath id="clip0-6">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-6)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 195.7178 710.8208)" x="0">V</text></g>
                  <path clip-path="url(#clip0-6)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 203.458 719.5688 L 202.269 719.5688 L 199.849 712.1628 L 197.276 719.5688 L 196.075 719.5688 L 199.222 710.8208 L 200.423 710.8208 L 203.458 719.5688 z "></path>
                  <g clip-path="url(#clip0-6)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 203.7222 710.8208)" x="0">I</text></g>
                  <path clip-path="url(#clip0-6)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 204.923 710.821 L 206.048 710.821 L 206.048 719.569 L 204.923 719.569 z "></path>
                  <g clip-path="url(#clip0-6)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 207.0581 710.8208)" x="0">D</text></g>
                  <clippath id="clip0-7">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-7)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 211.4995 710.8208 C 212.3625 710.8208 213.0855 711.0648 213.6675 711.5528 C 214.5975 712.3108 215.0625 713.5278 215.0625 715.2038 C 215.0625 716.3128 214.8455 717.2328 214.4115 717.9638 C 214.4115 717.9708 214.4075 717.9788 214.3995 717.9868 C 213.7705 719.0418 212.8045 719.5688 211.4995 719.5688 L 208.1245 719.5688 L 208.1245 710.8208 L 211.4995 710.8208 z M 209.2435 718.5848 L 211.3065 718.5848 C 211.5205 718.5848 211.7285 718.5648 211.9275 718.5258 C 213.2745 718.2678 213.9485 717.1548 213.9485 715.1858 C 213.9485 714.7408 213.9115 714.3388 213.8375 713.9788 C 213.5405 712.5298 212.6965 711.8048 211.3065 711.8048 L 209.2435 711.8048 L 209.2435 718.5848 z "></path>
                  <clippath id="clip0-8">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-8)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 215.7222 710.8208)" x="0">-</text></g>
                  <path clip-path="url(#clip0-8)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 216.273 713.704 L 219.132 713.704 L 219.132 714.565 L 216.273 714.565 z "></path>
                  <g clip-path="url(#clip0-8)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 219.7178 710.8208)" x="0">1</text></g>
                  <clippath id="clip0-9">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-9)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 222.8232 710.8208 L 223.8842 710.8208 L 223.8842 719.3288 L 223.1862 719.3288 L 223.0872 719.0178 C 222.9462 718.5688 222.7702 718.2598 222.5592 718.0918 C 222.3212 717.9008 221.8132 717.7528 221.0362 717.6468 L 220.9422 717.6348 L 220.9422 716.8798 L 222.8232 716.8798 L 222.8232 710.8208 z "></path>
                  <clippath id="clip0-10">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-10)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 226.3901 710.8208)" x="0">9</text></g>
                  <clippath id="clip0-11">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-11)" fill="none" stroke="#fff" stroke-width="0.462" stroke-linecap="round" stroke-linejoin="round" d="M 227.3979 711.6587 C 227.8389 710.9167 228.5189 710.5457 229.4369 710.5457 L 229.9179 710.5807 C 230.6949 710.7177 231.2939 711.1097 231.7159 711.7587 C 232.2359 712.5587 232.4959 713.6977 232.4959 715.1747 L 232.4959 715.3087 C 232.4799 716.5827 232.2419 717.5707 231.7809 718.2737 C 231.2999 718.9767 230.5839 719.3287 229.6299 719.3287 C 228.9269 719.3287 228.3279 719.1217 227.8319 718.7077 C 227.1749 718.1607 226.8469 717.4127 226.8469 716.4637 C 226.8469 715.7997 227.0229 715.2307 227.3749 714.7587 C 227.8709 714.0947 228.5659 713.7627 229.4609 713.7627 C 230.2459 713.7777 230.8939 714.0947 231.4059 714.7117 C 231.4059 714.1407 231.3529 713.6407 231.2479 713.2117 C 230.9779 712.0587 230.3979 711.4827 229.5069 711.4827 C 229.3819 711.4827 229.2629 711.4947 229.1499 711.5177 C 228.5839 711.6547 228.2279 712.0707 228.0839 712.7657 L 227.0289 712.7657 C 227.0909 712.3477 227.2139 711.9787 227.3979 711.6587 z M 230.6149 718.0807 C 231.1029 717.7137 231.3469 717.1817 231.3469 716.4867 C 231.3469 716.0997 231.2549 715.7637 231.0719 715.4787 C 230.7439 714.9597 230.2479 714.6997 229.5839 714.6997 C 229.2789 714.6997 229.0109 714.7587 228.7809 714.8757 C 228.2099 715.1727 227.9249 715.7287 227.9249 716.5457 C 227.9249 716.9597 228.0209 717.3187 228.2119 717.6237 L 228.2239 717.6357 C 228.5439 718.1467 229.0089 718.4027 229.6189 718.4027 C 229.9859 718.4027 230.3179 718.2957 230.6149 718.0807 z "></path>
                  <clippath id="clip0-12">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(12 0 0 -12 143.3682 696.4209)" x="0 0.667 1 1.556 2.056 2.278 2.778 3 3.556 4.112 4.668 4.89 5.168 5.835 6.391 6.891 7.391 7.613 8.169 8.725 9.003 9.225 9.781">Provisional Vaccination</text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(12 0 0 -12 178.3842 682.0209)" x="0 0.722 1.278 1.611 1.889 2.111 2.389 2.611 3.111 3.667 3.945">Certificate</text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 141.125 668.1748)" x="0 0.722 1.278 1.611 1.889 2.111 2.389 2.611 3.111 3.667 3.945 4.501 4.779 5.501 6.057">Certificate No:</text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 202.64 668.1748)"> <?php echo $data['certi_no']; ?> </text></g>
                  <g clip-path="url(#clip0-12)">
                     <g transform="matrix(0.2442 0 0 -0.2442 182.1133 662.5616)">
                        <image xlink:href="<?php echo $data['qr_code']; ?>" width="207" height="207" id="img58-0-13"></image>
                     </g>
                  </g>
                  <g clip-path="url(#clip0-12)">

                     <?php
                     $type = $data['type'];
                     if ($type == 'One') { ?>
                      <text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 152.6152 580.1748)" >NID Number</text>

                     <?php } else { ?>
                        <text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 124.6152 580.1748)" x="0 0.667 0.889 1.222 1.5 2.056 2.334 3.056 3.612 4.168 4.446 4.724 5.446 6.002 6.335 6.613 6.891 7.169 7.891 8.447">Birth Reg. Cert. No.</text>
                     <?php }
                     ?>

                  </g>
                  
                           <?php
                     $str_bt = $data['national_id'];
                     $digitc = strlen("$str_bt");
                     if ($digitc < 16 ) { ?>
                    <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6402 580.5748)"> <?php $str = $data['national_id'];
$parts = str_split($str, 16);
echo $parts[0]; ?> </text></g>
<?php } else { ?>
<g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6402 583.5748)"> <?php $str = $data['national_id'];
$parts = str_split($str, 16);
echo $parts[0]; ?> </text></g>
 <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6402 574.5748)"> <?php echo $parts[1]; ?> </text></g>

<?php } ?>

                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:arial; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6402 574.7748)"></text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 153.6222 562.4718)" x="0 0.667 1.223 1.723 2.223 2.779 3.335 3.668 3.946 4.224 4.946">Passport No</text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(8.64 0 0 -9 207.6401 562.4751)"> <?php echo $data['passport_no']; ?> </text></g>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 116.515 796.161 L 116.515 508.81 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 116.515 796.161 L 294.265 796.161 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 116.515 508.81 L 294.265 508.81 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 293.515 796.161 L 301.765 796.161 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 293.515 508.81 L 301.765 508.81 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 302.515 793.911 L 302.515 511.06 "></path>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 304.765 749.324 L 475.015 749.324 "></path>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 314.2393 723.436)" x="0 0.611 1.167 1.445 1.945 2.501 2.8335 3.0555 3.3335 3.8335 4.1115 4.3895 4.9455 5.1675 5.6675 5.9455 6.4455 7.0015 7.3345 7.6125 7.8345 8.1125 8.3345 8.8345 9.3905 9.6685 10.2245 10.5025 11.0585 11.2805 11.8365 12.3925 12.8925">To verify this certificate please</text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 308.2318 709.936)" x="0 0.5 0.722 1.222 1.444 1.722">visit </text></g>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 330.7318 709.936)" x="0">w</text></g>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 338.7021 715.8301 L 337.6421 715.8301 L 336.4731 711.2431 L 335.3181 715.8301 L 334.1711 715.8301 L 333.0451 711.2431 L 331.8421 715.8301 L 330.8031 715.8301 L 332.5171 709.9361 L 333.5721 709.9361 L 334.7091 714.5611 L 335.9001 709.9361 L 336.9721 709.9361 L 338.7021 715.8301 z "></path>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 338.8594 709.936)" x="0">w</text></g>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 346.8242 715.8301 L 345.7642 715.8301 L 344.5942 711.2431 L 343.4402 715.8301 L 342.2932 715.8301 L 341.1662 711.2431 L 339.9642 715.8301 L 338.9262 715.8301 L 340.6382 709.9361 L 341.6932 709.9361 L 342.8312 714.5611 L 344.0232 709.9361 L 345.0942 709.9361 L 346.8242 715.8301 z "></path>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 346.9824 709.936)" x="0">w</text></g>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 354.9473 715.8301 L 353.8873 715.8301 L 352.7173 711.2431 L 351.5633 715.8301 L 350.4163 715.8301 L 349.2893 711.2431 L 348.0873 715.8301 L 347.0493 715.8301 L 348.7613 709.9361 L 349.8163 709.9361 L 350.9543 714.5611 L 352.1463 709.9361 L 353.2173 709.9361 L 354.9473 715.8301 z "></path>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 355.1045 709.936)" x="0">.</text></g>
                  <path clip-path="url(#clip0-12)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 356.082 709.936 L 357.252 709.936 L 357.252 711.106 L 356.082 711.106 z "></path>
                  <g clip-path="url(#clip0-12)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 358.2324 709.936)" x="0">s</text></g>
                  <clippath id="clip0-14">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-14)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 363.0498 714.8633 C 362.7858 715.6213 362.1108 716.0003 361.0238 716.0003 C 360.5138 716.0003 360.0738 715.9073 359.7048 715.7203 C 359.0738 715.4053 358.7598 714.8983 358.7598 714.1983 L 358.7928 713.8203 C 358.8258 713.6623 358.8748 713.5233 358.9418 713.4023 C 359.1758 713.0173 359.7368 712.7173 360.6268 712.5013 L 361.5058 712.2873 L 361.5828 712.2653 L 361.5938 712.2653 C 361.6708 712.2433 361.7418 712.2213 361.8088 712.1993 C 362.2148 712.0563 362.4178 711.8133 362.4178 711.4683 C 362.4178 711.3183 362.3798 711.1863 362.3028 711.0733 C 362.0938 710.7213 361.6748 710.5463 361.0448 710.5463 C 360.5138 710.5463 360.1238 710.6763 359.8748 710.9353 C 359.7388 711.0863 359.6498 711.3373 359.6058 711.6883 L 358.6168 711.6883 L 358.6278 711.5013 C 358.7308 710.2853 359.5108 709.6773 360.9678 709.6773 C 361.5208 709.6773 361.9928 709.7753 362.3848 709.9683 C 363.0588 710.2993 363.3968 710.8243 363.3968 711.5453 C 363.3968 711.7473 363.3698 711.9263 363.3198 712.0843 C 363.1468 712.6113 362.6178 712.9793 361.7318 713.1883 L 360.8308 713.4023 L 360.4848 713.4903 C 359.9868 713.6553 359.7368 713.9053 359.7368 714.2423 C 359.7368 714.3703 359.7618 714.4843 359.8088 714.5833 C 359.9818 714.9493 360.3748 715.1333 360.9898 715.1333 C 361.7548 715.1333 362.1498 714.8173 362.1708 714.1873 L 363.1598 714.1873 C 363.1598 714.4363 363.1228 714.6623 363.0498 714.8633 z "></path>
                  <clippath id="clip0-15">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-15)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 363.8574 709.936)" x="0">u</text></g>
                  <clippath id="clip0-16">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-16)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 369.2793 715.8301 L 368.3453 715.8301 L 368.3453 712.4901 C 368.3453 712.0621 368.2703 711.6901 368.1203 711.3751 C 367.8343 710.7891 367.3733 710.4961 366.7363 710.4961 C 366.5273 710.4961 366.3433 710.5311 366.1863 710.6011 C 365.7433 710.7801 365.5213 711.1321 365.5213 711.6551 L 365.5213 715.8301 L 364.5883 715.8301 L 364.5883 711.2871 C 364.5883 710.9721 364.6593 710.6981 364.8023 710.4631 C 365.1093 709.9391 365.6653 709.6781 366.4663 709.6781 C 366.6533 709.6781 366.8223 709.6921 366.9713 709.7221 C 367.5283 709.8211 368.0173 710.1671 368.4383 710.7601 L 368.4383 709.9361 L 369.2793 709.9361 L 369.2793 715.8301 z "></path>
                  <clippath id="clip0-17">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-17)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 370.1123 709.936)" x="0">r</text></g>
                  <clippath id="clip0-18">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-18)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 370.8867 709.936 L 371.8317 709.936 L 371.8317 712.996 C 371.8317 713.82 372.0527 714.393 372.4957 714.715 L 372.5187 714.737 C 372.5327 714.748 372.5477 714.757 372.5627 714.765 C 372.7967 714.922 373.1827 715.004 373.7217 715.012 L 373.7217 715.968 L 373.4857 716 L 373.3647 716 C 372.9727 716 372.6187 715.836 372.3037 715.506 C 372.1247 715.319 371.9417 715.072 371.7547 714.765 L 371.7547 715.83 L 370.8867 715.83 L 370.8867 709.936 z "></path>
                  <clippath id="clip0-19">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-19)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 373.8584 709.936)" x="0">o</text></g>
                  <clippath id="clip0-20">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-20)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 375.4463 715.583 C 374.6583 715.059 374.2643 714.144 374.2643 712.836 C 374.2643 712.119 374.3873 711.513 374.6333 711.018 C 375.0833 710.125 375.8483 709.678 376.9283 709.678 C 377.5223 709.678 378.0293 709.824 378.4513 710.117 C 379.2123 710.648 379.5933 711.54 379.5933 712.792 C 379.5933 713.477 379.4853 714.063 379.2693 714.55 C 378.8413 715.517 378.0563 716 376.9183 716 C 376.3463 716 375.8563 715.861 375.4463 715.583 z M 377.6923 714.951 C 378.3073 714.607 378.6153 713.891 378.6153 712.804 C 378.6153 712.309 378.5373 711.886 378.3793 711.535 C 378.0863 710.875 377.6023 710.546 376.9283 710.546 C 376.6213 710.546 376.3523 710.617 376.1213 710.76 C 375.5353 711.119 375.2423 711.811 375.2423 712.836 C 375.2423 713.327 375.3143 713.748 375.4573 714.1 C 375.7423 714.788 376.2333 715.133 376.9283 715.133 C 377.2153 715.133 377.4683 715.072 377.6923 714.951 z "></path>
                  <clippath id="clip0-21">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-21)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 380.1133 709.936)" x="0">k</text></g>
                  <path clip-path="url(#clip0-21)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 380.7666 718.1372 L 380.7666 709.9362 L 381.7016 709.9362 L 381.7016 712.2322 L 382.6126 713.1332 L 384.6016 709.9362 L 385.7596 709.9362 L 383.3546 713.7922 L 385.4036 715.8302 L 384.1946 715.8302 L 381.7016 713.3312 L 381.7016 718.1372 L 380.7666 718.1372 z "></path>
                  <g clip-path="url(#clip0-21)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 385.7383 709.936)" x="0">k</text></g>
                  <path clip-path="url(#clip0-21)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 386.3916 718.1372 L 386.3916 709.9362 L 387.3266 709.9362 L 387.3266 712.2322 L 388.2376 713.1332 L 390.2266 709.9362 L 391.3846 709.9362 L 388.9796 713.7922 L 391.0286 715.8302 L 389.8196 715.8302 L 387.3266 713.3312 L 387.3266 718.1372 L 386.3916 718.1372 z "></path>
                  <g clip-path="url(#clip0-21)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 391.3633 709.936)" x="0">h</text></g>
                  <clippath id="clip0-22">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-22)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 392.1484 709.936 L 393.0834 709.936 L 393.0834 713.188 C 393.0834 713.624 393.1614 713.999 393.3184 714.314 C 393.5964 714.889 394.0504 715.177 394.6814 715.177 C 394.9964 715.177 395.2744 715.087 395.5154 714.907 C 395.7684 714.728 395.8954 714.431 395.8954 714.018 L 395.8954 709.936 L 396.8294 709.936 L 396.8294 714.391 C 396.8294 714.684 396.7704 714.942 396.6534 715.165 C 396.3604 715.722 395.7994 716 394.9724 716 L 394.7244 715.989 C 394.1654 715.953 393.6844 715.709 393.2864 715.259 L 393.0834 715.022 L 393.0834 718.137 L 392.1484 718.137 L 392.1484 709.936 z "></path>
                  <clippath id="clip0-23">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-23)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 397.6182 709.936)" x="0">a</text></g>
                  <clippath id="clip0-24">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-24)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 403.5889 710.4746 L 403.5779 710.4746 C 403.5419 710.4666 403.5009 710.4636 403.4569 710.4636 L 403.4359 710.4636 C 403.0989 710.4636 402.9299 710.6176 402.9299 710.9246 L 402.9299 714.3916 C 402.9299 714.5046 402.9229 714.6056 402.9079 714.6936 C 402.7659 715.5646 402.0329 716.0006 400.7109 716.0006 C 399.8179 716.0006 399.1649 715.7716 398.7549 715.3136 C 398.5059 715.0356 398.3709 714.6266 398.3489 714.0886 L 399.2939 714.0886 C 399.3009 714.1546 399.3119 714.2226 399.3259 714.2916 C 399.4549 714.8526 399.9049 715.1326 400.6779 715.1326 C 400.8199 715.1326 400.9559 715.1246 401.0839 715.1106 C 401.6929 715.0226 401.9959 714.7376 401.9959 714.2536 L 401.9959 714.0066 L 401.9629 713.8086 L 401.9629 713.7916 L 401.9629 713.7816 C 401.8789 713.5646 401.5629 713.4246 401.0129 713.3586 C 400.4599 713.2886 400.0709 713.2356 399.8489 713.1996 C 399.7719 713.1836 399.6999 713.1696 399.6339 713.1556 L 399.2499 713.0396 L 399.1229 712.9956 C 398.4349 712.7096 398.0909 712.1846 398.0909 711.4186 C 398.0909 711.0746 398.1619 710.7746 398.3049 710.5186 C 398.6269 709.9576 399.1999 709.6776 400.0249 709.6776 C 400.5259 709.6776 400.9869 709.8096 401.4079 710.0736 C 401.6099 710.1906 401.8169 710.3486 402.0289 710.5456 L 402.0509 710.3866 C 402.1509 709.9136 402.4649 709.6776 402.9959 709.6776 L 403.1059 709.6776 L 403.1169 709.6776 C 403.2449 709.6846 403.4189 709.7186 403.6389 709.7766 L 403.6389 710.4856 L 403.5889 710.4746 z M 401.8599 711.2866 C 401.7999 711.2036 401.7219 711.1176 401.6229 711.0296 C 401.2349 710.6736 400.7699 710.4956 400.2279 710.4956 C 400.0769 710.4956 399.9419 710.5126 399.8209 710.5456 C 399.3189 710.6556 399.0679 710.9536 399.0679 711.4416 L 399.0679 711.4526 L 399.1119 711.7486 C 399.2339 712.1516 399.6909 712.4096 400.4849 712.5236 L 401.4519 712.6716 C 401.6169 712.7076 401.7599 712.7516 401.8809 712.8036 L 401.9959 712.8476 L 401.9959 711.7926 C 401.9959 711.5916 401.9499 711.4226 401.8599 711.2866 z "></path>
                  <clippath id="clip0-25">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-25)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 403.873 709.936)" x="0">.</text></g>
                  <path clip-path="url(#clip0-25)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 404.851 709.936 L 406.021 709.936 L 406.021 711.106 L 404.851 711.106 z "></path>
                  <g clip-path="url(#clip0-25)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 407.001 709.936)" x="0">g</text></g>
                  <clippath id="clip0-26">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-26)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 411.6367 714.9785 C 411.1717 715.6605 410.5717 716.0005 409.8357 716.0005 C 409.2207 716.0005 408.6947 715.7905 408.2587 715.3685 C 407.6367 714.7755 407.3247 713.9135 407.3247 712.7815 C 407.3247 711.8075 407.5747 711.0345 408.0727 710.4635 C 408.5037 709.9765 409.0317 709.7145 409.6547 709.6775 L 409.7587 709.6775 C 409.8247 709.6775 409.8927 709.6815 409.9617 709.6885 C 410.5297 709.7325 411.0317 710.0475 411.4667 710.6335 L 411.5437 710.7325 L 411.5437 710.4305 C 411.5437 709.6655 411.4317 709.1285 411.2087 708.8205 C 410.9457 708.4545 410.5087 708.2715 409.9017 708.2715 C 409.4617 708.2715 409.1067 708.3755 408.8357 708.5845 L 408.8027 708.6065 C 408.6307 708.7565 408.5207 708.9745 408.4727 709.2605 L 407.5177 709.2605 C 407.5467 708.9675 407.6247 708.7055 407.7537 708.4745 C 408.1307 707.8155 408.8357 707.4865 409.8677 707.4865 C 409.9517 707.4865 410.0347 707.4895 410.1157 707.4975 C 410.9357 707.5415 411.5257 707.7885 411.8847 708.2385 L 412.0437 708.4535 C 412.3477 708.9325 412.4997 709.7495 412.4997 710.9025 L 412.4997 715.8305 L 411.6367 715.8305 L 411.6367 714.9785 z M 410.6207 714.9785 C 411.2367 714.6525 411.5437 713.9275 411.5437 712.8035 C 411.5437 712.3315 411.4777 711.9225 411.3457 711.5785 C 411.0817 710.8905 410.6167 710.5455 409.9507 710.5455 C 409.6577 710.5455 409.4017 710.6115 409.1817 710.7435 C 408.5997 711.0985 408.3087 711.7965 408.3087 712.8365 C 408.3087 713.3415 408.3837 713.7705 408.5327 714.1225 C 408.8087 714.7955 409.2777 715.1325 409.9397 715.1325 C 410.1927 715.1325 410.4197 715.0815 410.6207 714.9785 z "></path>
                  <clippath id="clip0-27">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-27)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 413.2559 709.936)" x="0">o</text></g>
                  <clippath id="clip0-28">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-28)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 414.8437 715.583 C 414.0557 715.059 413.6617 714.144 413.6617 712.836 C 413.6617 712.119 413.7847 711.513 414.0307 711.018 C 414.4807 710.125 415.2457 709.678 416.3257 709.678 C 416.9197 709.678 417.4267 709.824 417.8477 710.117 C 418.6097 710.648 418.9897 711.54 418.9897 712.792 C 418.9897 713.477 418.8827 714.063 418.6667 714.55 C 418.2387 715.517 417.4537 716 416.3157 716 C 415.7437 716 415.2537 715.861 414.8437 715.583 z M 417.0897 714.951 C 417.7047 714.607 418.0127 713.891 418.0127 712.804 C 418.0127 712.309 417.9347 711.886 417.7767 711.535 C 417.4837 710.875 416.9997 710.546 416.3257 710.546 C 416.0187 710.546 415.7497 710.617 415.5197 710.76 C 414.9327 711.119 414.6407 711.811 414.6407 712.836 C 414.6407 713.327 414.7117 713.748 414.8547 714.1 C 415.1397 714.788 415.6307 715.133 416.3257 715.133 C 416.6127 715.133 416.8657 715.072 417.0897 714.951 z "></path>
                  <clippath id="clip0-29">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-29)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 419.5107 709.936)" x="0">v</text></g>
                  <path clip-path="url(#clip0-29)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 424.9766 715.8301 L 423.9216 715.8301 L 422.2576 711.0511 L 420.6806 715.8301 L 419.6216 715.8301 L 421.6916 709.9361 L 422.7186 709.9361 L 424.9766 715.8301 z "></path>
                  <g clip-path="url(#clip0-29)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 425.1357 709.936)" x="0">.</text></g>
                  <path clip-path="url(#clip0-29)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 426.113 709.936 L 427.283 709.936 L 427.283 711.106 L 426.113 711.106 z "></path>
                  <g clip-path="url(#clip0-29)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 428.2627 709.936)" x="0">b</text></g>
                  <clippath id="clip0-30">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-30)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 428.8721 709.936 L 429.7131 709.936 L 429.7131 710.688 C 430.1561 710.015 430.7781 709.678 431.5801 709.678 C 432.1811 709.678 432.6951 709.861 433.1241 710.227 C 433.8061 710.806 434.1451 711.699 434.1451 712.908 C 434.1451 713.647 434.0071 714.274 433.7281 714.787 C 433.2851 715.596 432.5841 716 431.6251 716 C 430.8371 716 430.2311 715.678 429.8071 715.034 L 429.8071 718.137 L 428.8721 718.137 L 428.8721 709.936 z M 432.3551 714.831 C 432.8971 714.431 433.1681 713.755 433.1681 712.804 C 433.1681 712.28 433.0671 711.826 432.8661 711.441 C 432.5511 710.852 432.0781 710.557 431.4491 710.557 C 431.1151 710.557 430.8261 710.654 430.5811 710.848 C 430.0641 711.236 429.8071 711.899 429.8071 712.836 C 429.8071 713.364 429.8951 713.811 430.0751 714.177 C 430.3681 714.807 430.8261 715.122 431.4491 715.122 C 431.8081 715.114 432.1091 715.017 432.3551 714.831 z "></path>
                  <clippath id="clip0-31">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-31)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 434.5186 709.936)" x="0">d</text></g>
                  <clippath id="clip0-32">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-32)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 439.1543 718.1372 L 439.1543 715.0892 C 438.7563 715.6962 438.1513 716.0002 437.3423 716.0002 C 436.7493 716.0002 436.2393 715.8242 435.8143 715.4732 C 435.1443 714.9092 434.8093 714.0502 434.8093 712.8972 C 434.8093 712.1162 434.9523 711.4632 435.2383 710.9352 C 435.6883 710.0972 436.4003 709.6782 437.3753 709.6782 C 437.4673 709.6782 437.5523 709.6812 437.6333 709.6892 C 438.2773 709.7472 438.8173 710.0882 439.2543 710.7102 L 439.2543 709.9362 L 440.0893 709.9362 L 440.0893 718.1372 L 439.1543 718.1372 z M 438.3423 714.8632 C 438.8833 714.4822 439.1543 713.7992 439.1543 712.8142 C 439.1543 712.2902 439.0613 711.8422 438.8753 711.4692 C 438.5823 710.8612 438.1283 710.5562 437.5123 710.5562 C 437.1613 710.5562 436.8493 710.6572 436.5783 710.8592 C 436.0503 711.2652 435.7873 711.9252 435.7873 712.8362 C 435.7873 712.9642 435.7913 713.0852 435.7993 713.1992 C 435.8393 713.5792 435.9333 713.9132 436.0843 714.1992 C 436.3913 714.8142 436.8643 715.1212 437.5013 715.1212 C 437.8163 715.1212 438.0963 715.0352 438.3423 714.8632 z "></path>
                  <clippath id="clip0-33">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-33)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 440.7734 709.936)" x="0">/</text></g>
                  <path clip-path="url(#clip0-33)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 440.6855 709.7109 L 441.3005 709.7109 L 443.9705 718.1369 L 443.3495 718.1369 L 440.6855 709.7109 z "></path>
                  <g clip-path="url(#clip0-33)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 444.666 709.936)" x="0">v</text></g>
                  <path clip-path="url(#clip0-33)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 450.1318 715.8301 L 449.0768 715.8301 L 447.4118 711.0511 L 445.8358 715.8301 L 444.7758 715.8301 L 446.8468 709.9361 L 447.8738 709.9361 L 450.1318 715.8301 z "></path>
                  <g clip-path="url(#clip0-33)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 450.291 709.936)" x="0">e</text></g>
                  <clippath id="clip0-34">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-34)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 455.8281 714.4458 C 455.7361 714.6798 455.6151 714.8908 455.4661 715.0778 C 454.9781 715.6928 454.3031 716.0008 453.4381 716.0008 C 452.7941 716.0008 452.2461 715.8178 451.7961 715.4508 C 451.0931 714.8728 450.7411 713.9898 450.7411 712.8038 C 450.7411 712.0528 450.8881 711.4228 451.1811 710.9138 C 451.6531 710.0898 452.3981 709.6778 453.4171 709.6778 C 453.8231 709.6778 454.1911 709.7458 454.5201 709.8808 C 455.3011 710.2028 455.7731 710.8188 455.9371 711.7268 L 454.9931 711.7268 C 454.7291 710.9398 454.2151 710.5458 453.4491 710.5458 C 452.8311 710.5458 452.3581 710.7998 452.0321 711.3098 C 451.8311 711.6098 451.7261 712.0288 451.7191 712.5678 L 456.0641 712.5678 C 456.0641 713.4168 455.9851 714.0428 455.8281 714.4458 z M 452.0111 714.2918 C 452.3181 714.8528 452.7901 715.1328 453.4281 715.1328 C 453.7901 715.1328 454.1141 715.0248 454.4001 714.8088 C 454.8401 714.4718 455.0581 714.0028 455.0581 713.4028 L 455.0481 713.3308 L 451.7411 713.3308 C 451.7701 713.7008 451.8601 714.0208 452.0111 714.2918 z "></path>
                  <clippath id="clip0-35">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-35)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 456.5459 709.936)" x="0">r</text></g>
                  <clippath id="clip0-36">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-36)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 457.3203 709.936 L 458.2653 709.936 L 458.2653 712.996 C 458.2653 713.82 458.4863 714.393 458.9293 714.715 L 458.9523 714.737 C 458.9663 714.748 458.9813 714.757 458.9963 714.765 C 459.2303 714.922 459.6163 715.004 460.1553 715.012 L 460.1553 715.968 L 459.9193 716 L 459.7983 716 C 459.4063 716 459.0523 715.836 458.7373 715.506 C 458.5583 715.319 458.3753 715.072 458.1883 714.765 L 458.1883 715.83 L 457.3203 715.83 L 457.3203 709.936 z "></path>
                  <clippath id="clip0-37">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-37)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 460.292 709.936)" x="0">i</text></g>
                  <path clip-path="url(#clip0-37)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 461.045 709.936 L 461.979 709.936 L 461.979 715.83 L 461.045 715.83 z M 461.033 716.956 L 461.978 716.956 L 461.978 718.137 L 461.033 718.137 z "></path>
                  <g clip-path="url(#clip0-37)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 462.7891 709.936)" x="0">f</text></g>
                  <clippath id="clip0-38">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-38)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 464.7119 715.8301 L 464.7119 716.7531 C 464.7189 717.1521 464.9369 717.3511 465.3649 717.3511 L 465.4089 717.3511 L 465.6899 717.3411 L 465.6899 718.1151 L 465.3879 718.1591 L 465.1619 718.1701 C 464.9609 718.1701 464.7769 718.1441 464.6129 718.0931 C 464.0559 717.9141 463.7769 717.4931 463.7769 716.8301 L 463.7769 715.8301 L 462.9919 715.8301 L 462.9919 715.0661 L 463.7769 715.0661 L 463.7769 709.9361 L 464.7119 709.9361 L 464.7119 715.0661 L 465.6899 715.0661 L 465.6899 715.8301 L 464.7119 715.8301 z "></path>
                  <clippath id="clip0-39">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-39)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 465.917 709.936)" x="0">y</text></g>
                  <clippath id="clip0-40">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-40)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 468.6523 711.2432 L 467.1413 715.8302 L 466.1423 715.8302 L 468.1313 709.9142 L 467.7733 708.9802 L 467.7293 708.8542 C 467.5933 708.5542 467.3583 708.4032 467.0213 708.4032 C 466.8923 708.4032 466.7283 708.4272 466.5263 708.4742 L 466.5263 707.6292 C 466.7143 707.5342 466.9223 707.4862 467.1533 707.4862 C 467.2223 707.4862 467.2903 707.4902 467.3563 707.4972 C 467.6123 707.5342 467.8383 707.6232 468.0323 707.7662 C 468.2813 707.9462 468.4803 708.2192 468.6313 708.5852 L 468.6313 708.5962 L 468.6743 708.7002 L 471.2953 715.8302 L 470.2843 715.8302 L 468.6523 711.2432 z "></path>
                  <clippath id="clip0-41">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-41)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 384.8887 696.436)" x="0 0.556">or</text></g>
                  <g clip-path="url(#clip0-41)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 343.3087 682.936)" x="0">s</text></g>
                  <clippath id="clip0-42">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-42)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 348.1211 687.8633 C 347.8571 688.6213 347.1821 689.0003 346.0941 689.0003 C 345.5851 689.0003 345.1451 688.9073 344.7751 688.7203 C 344.1451 688.4053 343.8311 687.8983 343.8311 687.1983 L 343.8641 686.8203 C 343.8961 686.6623 343.9461 686.5233 344.0131 686.4023 C 344.2471 686.0173 344.8081 685.7173 345.6991 685.5013 L 346.5781 685.2873 L 346.6541 685.2653 L 346.6661 685.2653 C 346.7421 685.2433 346.8131 685.2213 346.8801 685.1993 C 347.2861 685.0563 347.4891 684.8133 347.4891 684.4683 C 347.4891 684.3183 347.4511 684.1863 347.3741 684.0733 C 347.1651 683.7213 346.7461 683.5463 346.1161 683.5463 C 345.5851 683.5463 345.1951 683.6763 344.9461 683.9353 C 344.8101 684.0863 344.7211 684.3373 344.6771 684.6883 L 343.6881 684.6883 L 343.6991 684.5013 C 343.8021 683.2853 344.5821 682.6773 346.0391 682.6773 C 346.5921 682.6773 347.0641 682.7753 347.4571 682.9683 C 348.1301 683.2993 348.4671 683.8243 348.4671 684.5453 C 348.4671 684.7473 348.4411 684.9263 348.3911 685.0843 C 348.2181 685.6113 347.6891 685.9793 346.8031 686.1883 L 345.9021 686.4023 L 345.5561 686.4903 C 345.0581 686.6553 344.8081 686.9053 344.8081 687.2423 C 344.8081 687.3703 344.8331 687.4843 344.8801 687.5833 C 345.0531 687.9493 345.4461 688.1333 346.0611 688.1333 C 346.8261 688.1333 347.2211 687.8173 347.2421 687.1873 L 348.2311 687.1873 C 348.2311 687.4363 348.1941 687.6623 348.1211 687.8633 z "></path>
                  <clippath id="clip0-43">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-43)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 348.9287 682.936)" x="0">c</text></g>
                  <clippath id="clip0-44">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-44)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 353.834 688.1216 L 353.746 688.2366 C 353.311 688.7466 352.695 689.0006 351.9 689.0006 C 351.285 689.0006 350.756 688.8176 350.313 688.4516 C 349.621 687.8726 349.274 686.9826 349.274 685.7816 C 349.274 685.0166 349.429 684.3746 349.736 683.8586 C 350.201 683.0716 350.919 682.6776 351.89 682.6776 C 352.307 682.6776 352.677 682.7526 352.999 682.9036 C 353.779 683.2466 354.211 683.9346 354.296 684.9626 L 353.351 684.9626 C 353.193 684.0176 352.714 683.5456 351.911 683.5456 C 351.618 683.5456 351.362 683.6076 351.143 683.7326 C 350.553 684.0736 350.258 684.7556 350.258 685.7816 C 350.258 686.2536 350.316 686.6626 350.434 687.0066 C 350.697 687.7576 351.183 688.1326 351.89 688.1326 C 352.032 688.1246 352.133 688.1176 352.191 688.1106 C 352.821 687.9966 353.186 687.5776 353.285 686.8526 L 354.23 686.8526 C 354.182 687.3766 354.05 687.7996 353.834 688.1216 z "></path>
                  <clippath id="clip0-45">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-45)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 354.5537 682.936)" x="0">a</text></g>
                  <clippath id="clip0-46">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-46)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 360.5244 683.4746 L 360.5134 683.4746 C 360.4774 683.4666 360.4364 683.4636 360.3924 683.4636 L 360.3714 683.4636 C 360.0344 683.4636 359.8654 683.6176 359.8654 683.9246 L 359.8654 687.3916 C 359.8654 687.5046 359.8584 687.6056 359.8434 687.6936 C 359.7014 688.5646 358.9684 689.0006 357.6464 689.0006 C 356.7534 689.0006 356.1004 688.7716 355.6904 688.3136 C 355.4414 688.0356 355.3064 687.6266 355.2844 687.0886 L 356.2294 687.0886 C 356.2364 687.1546 356.2474 687.2226 356.2614 687.2916 C 356.3904 687.8526 356.8404 688.1326 357.6134 688.1326 C 357.7554 688.1326 357.8914 688.1246 358.0194 688.1106 C 358.6284 688.0226 358.9314 687.7376 358.9314 687.2536 L 358.9314 687.0066 L 358.8984 686.8086 L 358.8984 686.7916 L 358.8984 686.7816 C 358.8144 686.5646 358.4984 686.4246 357.9484 686.3586 C 357.3954 686.2886 357.0064 686.2356 356.7844 686.1996 C 356.7074 686.1836 356.6354 686.1696 356.5694 686.1556 L 356.1854 686.0396 L 356.0584 685.9956 C 355.3704 685.7096 355.0264 685.1846 355.0264 684.4186 C 355.0264 684.0746 355.0974 683.7746 355.2404 683.5186 C 355.5624 682.9576 356.1354 682.6776 356.9604 682.6776 C 357.4614 682.6776 357.9224 682.8096 358.3434 683.0736 C 358.5454 683.1906 358.7524 683.3486 358.9644 683.5456 L 358.9864 683.3866 C 359.0864 682.9136 359.4004 682.6776 359.9314 682.6776 L 360.0414 682.6776 L 360.0524 682.6776 C 360.1804 682.6846 360.3544 682.7186 360.5744 682.7766 L 360.5744 683.4856 L 360.5244 683.4746 z M 358.7954 684.2866 C 358.7354 684.2036 358.6574 684.1176 358.5584 684.0296 C 358.1704 683.6736 357.7054 683.4956 357.1634 683.4956 C 357.0124 683.4956 356.8774 683.5126 356.7564 683.5456 C 356.2544 683.6556 356.0034 683.9536 356.0034 684.4416 L 356.0034 684.4526 L 356.0474 684.7486 C 356.1694 685.1516 356.6264 685.4096 357.4204 685.5236 L 358.3874 685.6716 C 358.5524 685.7076 358.6954 685.7516 358.8164 685.8036 L 358.9314 685.8476 L 358.9314 684.7926 C 358.9314 684.5916 358.8854 684.4226 358.7954 684.2866 z "></path>
                  <clippath id="clip0-47">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-47)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 360.8086 682.936)" x="0">n</text></g>
                  <clippath id="clip0-48">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-48)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 361.5937 682.936 L 362.5387 682.936 L 362.5387 686.188 C 362.5387 686.624 362.6167 686.999 362.7757 687.314 C 363.0537 687.889 363.5077 688.177 364.1377 688.177 C 364.3497 688.177 364.5377 688.144 364.7027 688.078 C 365.1357 687.891 365.3517 687.538 365.3517 687.018 L 365.3517 682.936 L 366.2847 682.936 L 366.2847 687.391 C 366.2787 687.713 366.2027 687.992 366.0607 688.226 C 365.7447 688.742 365.1977 689 364.4177 689 C 364.2387 689 364.0727 688.986 363.9227 688.957 C 363.3557 688.85 362.8677 688.478 362.4617 687.841 L 362.4617 688.83 L 361.5937 688.83 L 361.5937 682.936 z "></path>
                  <clippath id="clip0-49">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-49)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 367.0645 682.936)" x="0"> </text></g>
                  <g clip-path="url(#clip0-49)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 370.192 682.936)" x="0">t</text></g>
                  <clippath id="clip0-50">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-50)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 372.0811 688.8301 L 372.0811 690.4511 L 371.1471 690.4511 L 371.1471 688.8301 L 370.3511 688.8301 L 370.3511 688.0661 L 371.1471 688.0661 L 371.1471 683.6121 L 371.1581 683.4311 C 371.2421 682.9291 371.6181 682.6781 372.2841 682.6781 C 372.5001 682.6781 372.7551 682.7041 373.0481 682.7551 L 373.0481 683.5461 C 372.9351 683.5131 372.7841 683.4961 372.5981 683.4961 L 372.3281 683.5351 C 372.1631 683.5791 372.0811 683.7441 372.0811 684.0291 L 372.0811 688.0661 L 373.0481 688.0661 L 373.0481 688.8301 L 372.0811 688.8301 z "></path>
                  <clippath id="clip0-51">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-51)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 373.3193 682.936)" x="0">h</text></g>
                  <clippath id="clip0-52">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-52)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 374.1045 682.936 L 375.0395 682.936 L 375.0395 686.188 C 375.0395 686.624 375.1175 686.999 375.2755 687.314 C 375.5525 687.889 376.0065 688.177 376.6365 688.177 C 376.9525 688.177 377.2305 688.087 377.4725 687.907 C 377.7245 687.728 377.8515 687.431 377.8515 687.018 L 377.8515 682.936 L 378.7855 682.936 L 378.7855 687.391 C 378.7855 687.684 378.7265 687.942 378.6095 688.165 C 378.3165 688.722 377.7555 689 376.9285 689 L 376.6815 688.989 C 376.1215 688.953 375.6405 688.709 375.2425 688.259 L 375.0395 688.022 L 375.0395 691.137 L 374.1045 691.137 L 374.1045 682.936 z "></path>
                  <clippath id="clip0-53">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-53)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 379.5742 682.936)" x="0">e</text></g>
                  <clippath id="clip0-54">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-54)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 385.1113 687.4458 C 385.0193 687.6798 384.8983 687.8908 384.7493 688.0778 C 384.2613 688.6928 383.5863 689.0008 382.7213 689.0008 C 382.0773 689.0008 381.5293 688.8178 381.0793 688.4508 C 380.3763 687.8728 380.0243 686.9898 380.0243 685.8038 C 380.0243 685.0528 380.1713 684.4228 380.4643 683.9138 C 380.9363 683.0898 381.6813 682.6778 382.7003 682.6778 C 383.1063 682.6778 383.4743 682.7458 383.8033 682.8808 C 384.5843 683.2028 385.0563 683.8188 385.2203 684.7268 L 384.2763 684.7268 C 384.0123 683.9398 383.4983 683.5458 382.7323 683.5458 C 382.1143 683.5458 381.6413 683.7998 381.3153 684.3098 C 381.1143 684.6098 381.0093 685.0288 381.0023 685.5678 L 385.3473 685.5678 C 385.3473 686.4168 385.2683 687.0428 385.1113 687.4458 z M 381.2943 687.2918 C 381.6013 687.8528 382.0733 688.1328 382.7113 688.1328 C 383.0733 688.1328 383.3973 688.0248 383.6833 687.8088 C 384.1233 687.4718 384.3413 687.0028 384.3413 686.4028 L 384.3313 686.3308 L 381.0243 686.3308 C 381.0533 686.7008 381.1433 687.0208 381.2943 687.2918 z "></path>
                  <clippath id="clip0-55">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-55)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 385.8291 682.936)" x="0"> </text></g>
                  <g clip-path="url(#clip0-55)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 388.9566 682.936)" x="0">Q</text></g>
                  <clippath id="clip0-56">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-56)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 396.1465 683.793 C 396.9185 684.639 397.3055 685.707 397.3055 686.996 C 397.3055 688.204 396.9745 689.194 396.3115 689.967 C 395.5795 690.839 394.5895 691.274 393.3445 691.274 C 392.2575 691.274 391.3525 690.932 390.6315 690.248 C 389.7995 689.445 389.3845 688.354 389.3845 686.974 C 389.3845 685.769 389.7095 684.776 390.3625 683.996 C 391.0985 683.117 392.0925 682.678 393.3445 682.678 C 394.1325 682.678 394.8485 682.868 395.4935 683.249 L 396.6735 682.272 L 397.2015 682.925 L 396.1465 683.793 z M 393.8505 684.611 L 394.6795 683.914 C 394.4565 683.811 394.2485 683.732 394.0535 683.678 L 394.6795 683.914 C 394.0355 683.705 393.5865 683.601 393.3335 683.601 C 392.6125 683.601 392.0005 683.818 391.4995 684.254 C 390.7855 684.877 390.4275 685.783 390.4275 686.974 C 390.4275 687.867 390.6385 688.61 391.0595 689.204 C 391.5985 689.969 392.3605 690.352 393.3445 690.352 C 394.0705 690.352 394.6895 690.13 395.2025 689.687 C 395.9055 689.064 396.2565 688.164 396.2565 686.984 C 396.2565 685.944 395.9595 685.089 395.3665 684.419 L 394.3675 685.243 L 393.8505 684.611 z "></path>
                  <clippath id="clip0-57">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-57)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 397.709 682.936)" x="0">R</text></g>
                  <clippath id="clip0-58">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-58)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 402.499 686.4683 C 402.667 686.4683 402.817 686.4533 402.949 686.4243 C 403.55 686.2963 403.851 685.8233 403.851 685.0073 L 403.84 684.2763 C 403.84 683.7413 403.918 683.2953 404.075 682.9363 L 405.35 682.9363 L 405.35 683.1943 C 405.229 683.2783 405.134 683.3683 405.064 683.4633 C 404.939 683.6683 404.868 684.1303 404.85 684.8473 C 404.843 685.4923 404.776 685.9533 404.652 686.2323 C 404.51 686.5323 404.205 686.7833 403.74 686.9843 C 403.92 687.0763 404.081 687.1693 404.224 687.2643 C 404.762 687.6493 405.031 688.2093 405.031 688.9453 C 405.031 689.2603 404.991 689.5403 404.91 689.7863 C 404.603 690.6873 403.811 691.1373 402.537 691.1373 L 398.753 691.1373 L 398.753 682.9363 L 399.802 682.9363 L 399.802 686.4683 L 402.499 686.4683 z M 399.802 690.2143 L 402.334 690.2143 C 402.88 690.2143 403.273 690.1103 403.516 689.9013 C 403.801 689.6593 403.943 689.2913 403.943 688.7973 C 403.943 688.6323 403.928 688.4863 403.895 688.3583 C 403.763 687.7133 403.242 687.3913 402.334 687.3913 L 399.802 687.3913 L 399.802 690.2143 z "></path>
                  <clippath id="clip0-59">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-59)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 405.8311 682.936)" x="0"> </text></g>
                  <g clip-path="url(#clip0-59)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 408.9586 682.936)" x="0">c</text></g>
                  <clippath id="clip0-60">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-60)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 413.8643 688.1216 L 413.7763 688.2366 C 413.3413 688.7466 412.7253 689.0006 411.9303 689.0006 C 411.3153 689.0006 410.7863 688.8176 410.3433 688.4516 C 409.6513 687.8726 409.3043 686.9826 409.3043 685.7816 C 409.3043 685.0166 409.4593 684.3746 409.7663 683.8586 C 410.2313 683.0716 410.9493 682.6776 411.9203 682.6776 C 412.3373 682.6776 412.7073 682.7526 413.0293 682.9036 C 413.8093 683.2466 414.2413 683.9346 414.3263 684.9626 L 413.3813 684.9626 C 413.2233 684.0176 412.7443 683.5456 411.9413 683.5456 C 411.6483 683.5456 411.3923 683.6076 411.1733 683.7326 C 410.5833 684.0736 410.2883 684.7556 410.2883 685.7816 C 410.2883 686.2536 410.3463 686.6626 410.4643 687.0066 C 410.7273 687.7576 411.2133 688.1326 411.9203 688.1326 C 412.0623 688.1246 412.1633 688.1176 412.2213 688.1106 C 412.8513 687.9966 413.2163 687.5776 413.3153 686.8526 L 414.2603 686.8526 C 414.2123 687.3766 414.0803 687.7996 413.8643 688.1216 z "></path>
                  <clippath id="clip0-61">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-61)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 414.584 682.936)" x="0">o</text></g>
                  <clippath id="clip0-62">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-62)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 416.1719 688.583 C 415.3839 688.059 414.9899 687.144 414.9899 685.836 C 414.9899 685.119 415.1129 684.513 415.3589 684.018 C 415.8089 683.125 416.5739 682.678 417.6539 682.678 C 418.2479 682.678 418.7549 682.824 419.1759 683.117 C 419.9379 683.648 420.3179 684.54 420.3179 685.792 C 420.3179 686.477 420.2109 687.063 419.9949 687.55 C 419.5669 688.517 418.7819 689 417.6439 689 C 417.0719 689 416.5819 688.861 416.1719 688.583 z M 418.4179 687.951 C 419.0329 687.607 419.3409 686.891 419.3409 685.804 C 419.3409 685.309 419.2629 684.886 419.1049 684.535 C 418.8119 683.875 418.3279 683.546 417.6539 683.546 C 417.3469 683.546 417.0779 683.617 416.8479 683.76 C 416.2609 684.119 415.9689 684.811 415.9689 685.836 C 415.9689 686.327 416.0399 686.748 416.1829 687.1 C 416.4679 687.788 416.9589 688.133 417.6539 688.133 C 417.9409 688.133 418.1939 688.072 418.4179 687.951 z "></path>
                  <clippath id="clip0-63">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-63)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 420.8389 682.936)" x="0">d</text></g>
                  <clippath id="clip0-64">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-64)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 425.4746 691.1372 L 425.4746 688.0892 C 425.0766 688.6962 424.4716 689.0002 423.6626 689.0002 C 423.0696 689.0002 422.5596 688.8242 422.1346 688.4732 C 421.4646 687.9092 421.1296 687.0502 421.1296 685.8972 C 421.1296 685.1162 421.2726 684.4632 421.5586 683.9352 C 422.0086 683.0972 422.7206 682.6782 423.6956 682.6782 C 423.7876 682.6782 423.8726 682.6812 423.9536 682.6892 C 424.5976 682.7472 425.1376 683.0882 425.5746 683.7102 L 425.5746 682.9362 L 426.4096 682.9362 L 426.4096 691.1372 L 425.4746 691.1372 z M 424.6626 687.8632 C 425.2036 687.4822 425.4746 686.7992 425.4746 685.8142 C 425.4746 685.2902 425.3816 684.8422 425.1956 684.4692 C 424.9026 683.8612 424.4486 683.5562 423.8326 683.5562 C 423.4816 683.5562 423.1696 683.6572 422.8986 683.8592 C 422.3706 684.2652 422.1076 684.9252 422.1076 685.8362 C 422.1076 685.9642 422.1116 686.0852 422.1196 686.1992 C 422.1596 686.5792 422.2536 686.9132 422.4046 687.1992 C 422.7116 687.8142 423.1846 688.1212 423.8216 688.1212 C 424.1366 688.1212 424.4166 688.0352 424.6626 687.8632 z "></path>
                  <clippath id="clip0-65">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-65)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 427.0937 682.936)" x="0">e</text></g>
                  <clippath id="clip0-66">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-66)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 432.6309 687.4458 C 432.5389 687.6798 432.4179 687.8908 432.2689 688.0778 C 431.7809 688.6928 431.1059 689.0008 430.2409 689.0008 C 429.5969 689.0008 429.0489 688.8178 428.5989 688.4508 C 427.8959 687.8728 427.5439 686.9898 427.5439 685.8038 C 427.5439 685.0528 427.6909 684.4228 427.9839 683.9138 C 428.4559 683.0898 429.2009 682.6778 430.2199 682.6778 C 430.6259 682.6778 430.9939 682.7458 431.3229 682.8808 C 432.1039 683.2028 432.5759 683.8188 432.7399 684.7268 L 431.7959 684.7268 C 431.5319 683.9398 431.0179 683.5458 430.2519 683.5458 C 429.6339 683.5458 429.1609 683.7998 428.8349 684.3098 C 428.6339 684.6098 428.5289 685.0288 428.5219 685.5678 L 432.8669 685.5678 C 432.8669 686.4168 432.7879 687.0428 432.6309 687.4458 z M 428.8139 687.2918 C 429.1209 687.8528 429.5929 688.1328 430.2309 688.1328 C 430.5929 688.1328 430.9169 688.0248 431.2029 687.8088 C 431.6429 687.4718 431.8609 687.0028 431.8609 686.4028 L 431.8509 686.3308 L 428.5439 686.3308 C 428.5729 686.7008 428.6629 687.0208 428.8139 687.2918 z "></path>
                  <clippath id="clip0-67">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <g clip-path="url(#clip0-67)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt" transform="matrix(11.25 0 0 -11.25 433.3486 682.936)" x="0">.</text></g>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#000" stroke-width="0.433" stroke-linecap="round" stroke-linejoin="round" d="M 434.326 682.936 L 435.496 682.936 L 435.496 684.106 L 434.326 684.106 z "></path>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#000" stroke-width="0.75" stroke-linecap="square" d="M 375.966 670.574 L 403.814 670.574 "></path>
                  <g clip-path="url(#clip0-67)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 305.166 643.186)" x="0 0.611 1.167 1.4995 1.7775 2.3335 2.8895 3.3895 3.6675 3.9455 4.5015 4.834 5.112 5.668 6.224 6.5565 6.8345 7.3905 7.8905 8.3905 8.6125 9.1125 9.3905 9.9465 10.5025 11.0025 11.5585 11.8365 12.1145 12.6705 12.8925 13.4485 14.0045 14.5045">For any further assistance, please</text></g>
                  <g clip-path="url(#clip0-67)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 327.6773 629.686)" x="0 0.5 0.722 1.222 1.444 1.722 2 2.722 3.444 4.166 4.444 5 5.556 6.112 6.612 6.89 7.446 8.002 8.502 8.78 9.336 9.892 10.17 10.726">visit www.dghs.gov.bd or</text></g>
                  <g clip-path="url(#clip0-67)"><text stroke="none" fill="#000" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(11.25 0 0 -11.25 326.0235 616.186)" x="0 0.556 0.889 1.7215 2.2775 2.4995 2.7215 2.9995 3.2775 3.4995 4.0555 4.3335 4.8895 5.9045 6.4605 7.0165 7.5725 8.0725 8.3505 8.9065 9.4625 9.9625 10.2405 10.7965">e-mail: info@dghs.gov.bd</text></g>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 304.765 596.324 L 475.015 596.324 "></path>
                  <g clip-path="url(#clip0-67)">
                     <g transform="matrix(0.2542 0 0 -0.2542 344.89 580.95)">
                        <image xlink:href="data:image/png;base64,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" width="354" height="101" id="img59-0-68"></image>
                     </g>
                  </g>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 301.015 796.161 L 478.765 796.161 "></path>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 478.765 796.161 L 478.765 508.81 "></path>
                  <path clip-path="url(#clip0-67)" fill="none" stroke="#008000" stroke-width="0.75" stroke-linecap="square" d="M 301.015 508.81 L 478.765 508.81 "></path>
                  <g clip-path="url(#clip0-67)"><text stroke="#000" stroke-width="0.5" fill="#000" style="font-family:sans-serif; font-size:6.75pt; white-space:pre" x="65" y="-2" dominant-baseline="middle" text-anchor="middle" transform="matrix(1 0 0 -1 140.131 597.875)"> <?php echo $data['name']; ?> </text></g>
                  <clippath id="clip0-69">
                     <path d="M 0 0 L 596 0 L 596 842 L 0 842 L 0 0 z "></path>
                  </clippath>
                  <clippath id="clip0-70">
                     <path d="M 0 0 L 595.28 0 L 595.28 841.89 L 0 841.89 L 0 0 z "></path>
                  </clippath>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 119.855 558.586 L 204.605 558.586 L 204.605 547.786 L 119.855 547.786 z "></path>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 206.105 558.586 L 290.855 558.586 L 290.855 547.786 L 206.105 547.786 z "></path>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 119.855 546.286 L 204.605 546.286 L 204.605 524.686 L 119.855 524.686 z "></path>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 206.105 546.286 L 290.855 546.286 L 290.855 524.686 L 206.105 524.686 z "></path>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 119.855 523.186 L 204.605 523.186 L 204.605 512.386 L 119.855 512.386 z "></path>
                  <path clip-path="url(#clip0-70)" fill="#008000" stroke="none" d="M 206.105 523.186 L 290.855 523.186 L 290.855 512.386 L 206.105 512.386 z "></path>
                  <g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 161.0933 550.1753)">Nationality &nbsp;Bangladeshi</text></g>
                  <g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 144.5873 532.4723)" x="0 0.667 1.223 1.723 2.223 2.445 3.001 3.557 3.835 4.557 5.113 5.946">Vaccine Name</text></g>

                 <?php  
                 
                 $tds = $data['doseone_name']; 
                
						if($tds=='1'){?>
						
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">Pfizer (Pfizer-</text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">BioNTech) </text></g>
						
						
						
						<?php }
						elseif($tds=='2'){?>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">COVISHIELD  </text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">(AstraZeneca)</text></g>
						
						
						<?php }
						
						elseif($tds=='3'){?>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">Moderna  </text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">(Moderna) </text></g>
						
						
						<?php }
						elseif($tds=='4'){?>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">Vero Cell</text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">(Sinopharm) </text></g>
						
						
						<?php }
						
						elseif($tds=='5'){?>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">Janssen (Johnson</text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">&Johnson)</text></g>
						
						
                  <?php }
						
						elseif($tds=='6'){?>
						
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 537.8723)">Pfizer</text></g>
						
						
						
						<?php }
						else{?>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 207.6053 532.8723)"><?php echo $data['doseone_name'];  ?></text></g>
						
						<g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 527.0723)">  </text></g>
						
						
						<?php }
						
						?>


                  <g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt; white-space:pre" transform="matrix(9 0 0 -9 155.0903 514.7693)" x="0 0.611 1.167 1.445 2.001 2.223 2.501 3.223 3.779 4.279 4.835">Total Doses</text></g>
                  <g clip-path="url(#clip0-70)"><text stroke="none" fill="#fff" style="font-family:f0-0; font-size:0.75pt" transform="matrix(9 0 0 -9 207.6053 514.7693)" x="0"> <?php echo $data['total_dose']; ?> </text></g>
               </g>
            </svg>
         </svg>
      </g>
   </svg>
   <br>
</body>

</html>