<?php
// Include database connection and session check
session_start();
require_once "../includes/config.php";

// Example: Fetch data from database or session
$email = $_SESSION['alogin'];

// Check if trxID is provided in the URL
if (isset($_GET['trxID'])) {
    $trxID = $_GET['trxID'];

    // Fetch the payment record for the logged-in user based on trxID
    $sql = "SELECT * FROM payment WHERE email = :email AND trxID = :trxID LIMIT 1";
    $query = $dbh->prepare($sql);
    $query->bindParam(':email', $email, PDO::PARAM_STR);
    $query->bindParam(':trxID', $trxID, PDO::PARAM_STR);
    $query->execute();
    $payment = $query->fetch(PDO::FETCH_OBJ);

    // Fetch user information
    $sql2 = "SELECT * FROM users WHERE email = :email";
    $query2 = $dbh->prepare($sql2);
    $query2->bindParam(':email', $email, PDO::PARAM_STR);
    $query2->execute();
    $result = $query2->fetch(PDO::FETCH_OBJ);

    // If no record is found, display an error
    if (!$payment) {
        die("No payment record found for this transaction ID.");
    }

    // Assign variables from the database result
    $customerName = htmlentities($result->name ?? 'N/A');
    $customerPhone = htmlentities($payment->customerMsisdn ?? 'N/A');
    $purchaseDate = htmlentities((($payment->paymentExecuteTime ?? 'now')));
    $productName = htmlentities($payment->productName ?? 'Website Recharge');
    $productID = htmlentities($payment->id ?? 'N/A');
    $productPrice = htmlentities($payment->amount ?? '0');
    $paymentMethod = htmlentities($payment->paymentMethod ?? 'Bkash');
    $totalPay = htmlentities($payment->amount ?? '0');
    $transactionNumber = htmlentities($payment->customerMsisdn ?? 'N/A');
    $transactionID = htmlentities($payment->trxID ?? 'N/A');

} else {
    die("Transaction ID not provided.");
}

// Your HTML output code would go here to display the information.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Money Receipt</title>
    <link rel="stylesheet" href="styles.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link href='https://fonts.googleapis.com/css?family=Anek Bangla' rel='stylesheet'>
</head>
<body>
    <div class="receipt" id="receipt-content">
        <!-- Header Section -->
        <div class="header">
            <div class="logo">
                <img src="logo.png" alt="BD TOOL BD Logo">
            </div>
            <div class="company-info">
                <h2>BD TOOL BD</h2>
                <p>Website Recharge</p>
                <p>Search - bdtoolbd.xyz</p>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="content">
            <h3 class="money-receipt-title">Money Receipt</h3>
            <p><strong><?php echo $customerName; ?></strong></p>
            <p><?php echo $customerPhone; ?></p>
            <p><strong>Purchase Date:</strong> <span><?php echo $purchaseDate; ?></span></p>

            <!-- Details Table -->
            <table>
                <tr>
                    <th>Name</th>
                    <th>ID</th>
                    <th>Price</th>
                </tr>
                <tr>
                    <td><?php echo $productName; ?></td>
                    <td><?php echo $productID; ?></td>
                    <td><?php echo $productPrice; ?> ৳</td>
                </tr>
            </table>

            <!-- Payment Info -->
            <table class="payment-table">
                <tr>
                    <th><strong>METHOD</strong></th>
                    <th class="align-right"><strong>TOTAL PAY</strong></th>
                </tr>
                <tr>
                    <td><?php echo $paymentMethod; ?></td>
                    <td class="align-right"><?php echo $totalPay; ?> ৳</td>
                </tr>
            </table>

            <!-- Transaction Info -->
            <table class="transaction-table">
                <tr class="header-row">
                    <th><strong>NUMBER</strong></th>
                    <th class="align-right"><strong>TXID</strong></th>
                </tr>
                <tr>
                    <td><?php echo $transactionNumber; ?></td>
                    <td class="align-right"><?php echo $transactionID; ?></td>
                </tr>
            </table>
        </div>

        <!-- Footer Section -->
        <div class="footer">
            <h1>BD TOOL BD</h1>
            <h3>TEAMS & CONDITIONS</h3>
            <p>
                এই ডকুমেন্টটি সংরক্ষ করে রাখবেন। এই ডকুমেন্ট দেখিয়ে আমাদের কাছ থেকে যে কোনো সমস্যা এর সমাধান নিতে পারবেন।
            </p>
        </div>
    </div>

    <div class="button" id="1">
        <ul>
            <li class="btn btn1">
                <a class="a1" href="javascript:downloadAsImage()">Save as img</a>
            </li>
            <li class="btn btn2">
                <a class="a2" href="javascript:downloadAsPDF()">Save as pdf</a>
            </li>
        </ul>
    </div>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script>
    // Download the content as an image
    function downloadAsImage() {
        const content = document.getElementById('receipt-content');
        html2canvas(content).then(canvas => {
            const image = canvas.toDataURL('image/png');
            const link = document.createElement('a');
            link.href = image;
            link.download = 'receipt.png';
            link.click();
        });
    }

    // Download the content as a PDF
    function downloadAsPDF() {
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF();
        const content = document.getElementById('receipt-content');

        html2canvas(content).then(canvas => {
            const imgData = canvas.toDataURL('image/png');
            const imgWidth = 190; // PDF width
            const imgHeight = (canvas.height * imgWidth) / canvas.width; // Maintain aspect ratio

            pdf.addImage(imgData, 'PNG', 10, 10, imgWidth, imgHeight);
            pdf.save('receipt.pdf');
        });
    }
</script>
</html>