<?php
if (!isset($_GET['tin']) || empty($_GET['tin'])) {
    die("TIN parameter is required.");
}

$tin = $_GET['tin']; // Get the TIN from URL parameter

$url = "https://secure.incometax.gov.bd/ViewCertiifcate";
$data = "NEW_TIN=" . urlencode($tin);

$headers = [
    "Host: secure.incometax.gov.bd",
    "content-length: " . strlen($data),
    "sec-ch-ua-platform: \"Android\"",
    "x-requested-with: XMLHttpRequest",
    "user-agent: Mozilla/5.0 (Linux; Android 11; RMX3231 Build/RP1A.201005.001) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.6834.164 Mobile Safari/537.36",
    "accept: */*",
    "sec-ch-ua: \"Not A(Brand\";v=\"8\", \"Chromium\";v=\"132\", \"Android WebView\";v=\"132\"",
    "content-type: application/x-www-form-urlencoded",
    "sec-ch-ua-mobile: ?1",
    "origin: https://secure.incometax.gov.bd",
    "sec-fetch-site: same-origin",
    "sec-fetch-mode: cors",
    "sec-fetch-dest: empty",
    "referer: https://secure.incometax.gov.bd/ViewCertiifcate",
    "accept-encoding: gzip, deflate, br, zstd",
    "accept-language: en-US,en;q=0.9",
    "cookie: ASP.NET_SessionId=iifyb1ka1h33e1rg2q3awr41",
    "priority: u=1, i"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_ENCODING, "gzip, deflate, br");

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code != 200) {
    die("Error fetching data. HTTP Code: " . $http_code);
}

// Remove unwanted section from the response using regex
$response = preg_replace('/<div class="before_footer" id="div_print_command">.*?<\/div>/s', '', $response);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TIN CERTIFICATE - <?php echo htmlspecialchars($tin); ?></title>
    <style>
    
    
@import url('https://fonts.maateen.me/solaiman-lipi/font.css');

			@page {

				size: A4;

				margin: auto;

			}



			body {

				margin: 0;
				font-family: Solaimanlipi;
             font-weight: regular;
             padding: 30px;

			}
  
            
        }
        .btn-container {
            text-align: center;
            margin-bottom: 20px;
        }
        button {
            padding: 10px 20px;
            font-size: 16px;
            margin: 5px;
            cursor: pointer;
        }
    
        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            .PrintBtn {
                display: none;
            }
        }
    </style>
</head>
<body>

   
    <div id="certificate">
        <?php echo $response; ?>
    </div>

</body>
 <script>
        window.print();
        document.addEventListener('contextmenu', event => event.preventDefault());
        function handleClick(event) {
            window.print();
        }
        document.addEventListener('click', handleClick);
    </script>

</html>