<?php
header("Content-Type: application/json");

// Load key and balance from key.json
$keyFile = __DIR__ . '/data/key.json';

// Check if file exists and is readable, log any issues
if (!file_exists($keyFile)) {
    error_log("File not found: " . $keyFile);
    echo json_encode([
        "code" => 500,
        "success" => "false",
        "message" => "Configuration file not found"
    ]);
    exit;
}

if (!is_readable($keyFile)) {
    error_log("File not readable: " . $keyFile);
    echo json_encode([
        "code" => 500,
        "success" => "false",
        "message" => "Configuration file not readable"
    ]);
    exit;
}

// Attempt to load and decode JSON
$keyData = json_decode(file_get_contents($keyFile), true);

// Check if JSON decoding was successful
if ($keyData === null) {
    error_log("JSON decoding error: " . json_last_error_msg());
    echo json_encode([
        "code" => 500,
        "success" => "false",
        "message" => "Error decoding JSON data"
    ]);
    exit;
}

// Check if the key parameter is provided
if (!isset($_GET['key'])) {
    echo json_encode([
        "code" => 400,
        "success" => "false",
        "message" => "Key parameter is required"
    ]);
    exit;
}

$providedKey = $_GET['key'];

// Search for the key in the keys array
$foundKey = null;
foreach ($keyData['keys'] as $keyEntry) {
    if ($keyEntry['key'] === $providedKey) {
        $foundKey = $keyEntry;
        break;
    }
}

// If the key was not found
if ($foundKey === null) {
    echo json_encode([
        "code" => 401,
        "success" => "false",
        "message" => "Invalid API key"
    ]);
    exit;
}

// Send successful response with the balance
echo json_encode([
    "code" => 200,
    "success" => "true",
    "balance" => $foundKey['balance']
]);
?>
