<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$keyFile = __DIR__ . '/data/key.json';

// Load the existing keys and balances
$keyData = json_decode(file_get_contents($keyFile), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        $key = $_POST['key'] ?? '';
        $balance = (int)($_POST['balance'] ?? 0);

        if ($action === 'add') {
            // Add a new key
            $keyData['keys'][] = ['key' => $key, 'balance' => $balance];
        } elseif ($action === 'update') {
            // Update existing key balance
            foreach ($keyData['keys'] as &$entry) {
                if ($entry['key'] === $key) {
                    $entry['balance'] = $balance;
                    break;
                }
            }
        } elseif ($action === 'delete') {
            // Delete a key
            $keyData['keys'] = array_filter($keyData['keys'], function($entry) use ($key) {
                return $entry['key'] !== $key;
            });

            // Re-index array to avoid any issues with non-numeric keys after filtering
            $keyData['keys'] = array_values($keyData['keys']);
        }

        // Save updated data back to the JSON file
        file_put_contents($keyFile, json_encode($keyData, JSON_PRETTY_PRINT));
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel</title>
    <style>
        /* General reset */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        /* Body Styling */
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            font-family: Arial, sans-serif;
            background: #f4f4f9;
            color: #333;
            padding: 1rem;
        }

        /* Admin Panel Box Styling */
        .admin-box {
            max-width: 600px;
            width: 100%;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }

        .admin-box h2 {
            margin-bottom: 1rem;
            color: #444;
        }

        .admin-box h3 {
            margin-top: 1.5rem;
            margin-bottom: 1rem;
            color: #333;
        }

        /* Form Styling */
        form {
            display: flex;
            flex-direction: column;
            margin-bottom: 1.5rem;
        }

        label, button {
            font-size: 1rem;
            margin-bottom: 0.5rem;
        }

        input {
            padding: 0.8rem;
            margin-bottom: 1rem;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        button {
            padding: 0.8rem;
            border: none;
            border-radius: 4px;
            color: #fff;
            background-color: #0066cc;
            cursor: pointer;
            font-size: 1rem;
        }

        button:hover {
            background-color: #005bb5;
        }

        /* Existing Keys List */
        ul {
            list-style-type: none;
            padding: 0;
            margin-top: 1rem;
            font-size: 0.9rem;
        }

        ul li {
            margin-bottom: 0.5rem;
        }

        /* Logout link */
        .logout {
            display: inline-block;
            margin-top: 1rem;
            font-size: 0.9rem;
            color: #0066cc;
            text-decoration: none;
        }

        .logout:hover {
            color: #005bb5;
        }

        /* Responsive Design */
        @media (max-width: 600px) {
            .admin-box {
                padding: 1.5rem;
            }

            input, button {
                font-size: 0.9rem;
            }

            h2, h3 {
                font-size: 1.2rem;
            }
        }
    </style>
</head>
<body>
    <div class="admin-box">
        <h2>Admin Panel</h2>
        <a href="logout.php" class="logout">Logout</a>
        <hr>

        <h3>Add New Key</h3>
        <form method="POST">
            <input type="hidden" name="action" value="add">
            <label>Key:</label>
            <input type="text" name="key" required>
            <label>Balance:</label>
            <input type="number" name="balance" required>
            <button type="submit">Add Key</button>
        </form>

        <h3>Update Key Balance</h3>
        <form method="POST">
            <input type="hidden" name="action" value="update">
            <label>Key:</label>
            <input type="text" name="key" required>
            <label>New Balance:</label>
            <input type="number" name="balance" required>
            <button type="submit">Update Balance</button>
        </form>

        <h3>Delete Key</h3>
        <form method="POST">
            <input type="hidden" name="action" value="delete">
            <label>Key:</label>
            <input type="text" name="key" required>
            <button type="submit">Delete Key</button>
        </form>

        <h3>Existing Keys</h3>
        <ul>
            <?php foreach ($keyData['keys'] as $entry): ?>
                <li>Key: <?= htmlspecialchars($entry['key']) ?> - Balance: <?= htmlspecialchars($entry['balance']) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
</body>
</html>
