<?php 
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
} else {
    if (isset($_GET['del']) && isset($_GET['name'])) {
        $id = $_GET['del'];
        $name = $_GET['name'];

        $sql = "DELETE FROM users WHERE id=:id";
        $query = $dbh->prepare($sql);
        $query->bindParam(':id', $id, PDO::PARAM_STR);
        $query->execute();

        $sql2 = "INSERT INTO deleteduser (email) VALUES (:name)";
        $query2 = $dbh->prepare($sql2);
        $query2->bindParam(':name', $name, PDO::PARAM_STR);
        $query2->execute();

        $msg = "Data Deleted successfully";
    }

    if (isset($_REQUEST['unconfirm'])) {
        $aeid = intval($_GET['unconfirm']);
        $memstatus = 1;
        $sql = "UPDATE users SET status=:status WHERE id=:aeid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':status', $memstatus, PDO::PARAM_STR);
        $query->bindParam(':aeid', $aeid, PDO::PARAM_STR);
        $query->execute();
        $msg = "Changes Successfully";
    }

    if (isset($_REQUEST['confirm'])) {
        $aeid = intval($_GET['confirm']);
        $memstatus = 0;
        $sql = "UPDATE users SET status=:status WHERE id=:aeid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':status', $memstatus, PDO::PARAM_STR);
        $query->bindParam(':aeid', $aeid, PDO::PARAM_STR);
        $query->execute();
        $msg = "Changes Successfully";
    }

    // Update SMS Rate
    if (isset($_POST['set_sms_rate'])) {
        $sms_rate = $_POST['sms_rate'];
        $sql = "UPDATE sms_settings SET rate=:sms_rate WHERE id=1";
        $query = $dbh->prepare($sql);
        $query->bindParam(':sms_rate', $sms_rate, PDO::PARAM_STR);
        $query->execute();
        $msg = "SMS rate updated successfully";
    }

    // Toggle SMS Service
    if (isset($_POST['toggle_sms_service'])) {
        $sms_status = $_POST['sms_status'] == 'on' ? 1 : 0;
        $sql = "UPDATE sms_settings SET service_status=:sms_status WHERE id=1";
        $query = $dbh->prepare($sql);
        $query->bindParam(':sms_status', $sms_status, PDO::PARAM_INT);
        $query->execute();
        $msg = "SMS service status updated successfully";
    }

    // Fetch all SMS settings
    $sql = "SELECT * FROM `sms_settings`";
    $query = $dbh->prepare($sql);
    $query->execute();
    $settings = $query->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($settings)) {
        $sms_rate = $settings[0]['rate'];
        $sms_service_status = $settings[0]['service_status'] ? 'on' : 'off';
    } else {
        $sms_rate = 0; // Default rate if no settings are found
        $sms_service_status = 'off';
    }

    // Fetch all SMS transactions for history
    $sql = "SELECT * FROM `sms_transactions` ORDER BY sent_at DESC";
    $query = $dbh->prepare($sql);
    $query->execute();
    $sms_history = $query->fetchAll(PDO::FETCH_OBJ);
?>

<!doctype html>
<html lang="en" class="no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <title>Manage Users and SMS Settings</title>
    <script src="https://code.jquery.com/jquery-3.6.4.slim.min.js"></script>
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .errorWrap { padding: 10px; margin: 0 0 20px 0; background: #dd3d36; color: #fff; }
        .succWrap { padding: 10px; margin: 0 0 20px 0; background: #5cb85c; color: #fff; }
    </style>
</head>

<body>
    <?php include('includes/header.php'); ?>
    <div class="ts-main-content">
        <?php include('includes/leftbar.php'); ?>
        <div class="content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <h2 class="page-title">Admin Panel</h2>
                        
                        <!-- SMS Settings Form -->
                        <div class="panel panel-default">
                            <div class="panel-heading">SMS Settings</div>
                            <div class="panel-body">
                                <?php if ($msg) { ?>
                                    <div class="succWrap" id="msgshow"><?php echo htmlentities($msg); ?> </div>
                                <?php } ?>
                                
                                <form method="POST" action="">
                                    <div class="form-group">
                                        <label for="sms_rate">Set SMS Rate (in BDT):</label>
                                        <input type="text" name="sms_rate" class="form-control" value="<?php echo $sms_rate; ?>" required>
                                    </div>
                                    <button type="submit" name="set_sms_rate" class="btn btn-primary">Save SMS Rate</button>
                                </form>
                                
                                <form method="POST" action="" style="margin-top: 20px;">
                                    <div class="form-group">
                                        <label for="sms_service">Toggle SMS Service:</label>
                                        <select name="sms_status" class="form-control" required>
                                            <option value="on" <?php echo $sms_service_status == 'on' ? 'selected' : ''; ?>>On</option>
                                            <option value="off" <?php echo $sms_service_status == 'off' ? 'selected' : ''; ?>>Off</option>
                                        </select>
                                    </div>
                                    <button type="submit" name="toggle_sms_service" class="btn btn-warning">Toggle SMS Service</button>
                                </form>
                            </div>
                        </div>

                        <!-- SMS History -->
                        <div class="panel panel-default">
                            <div class="panel-heading">SMS History</div>
                            <div class="panel-body">
                                <table id="smsHistory" class="display table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Sender Email</th>
                                            <th>Receiver Number</th>
                                            <th>Message</th>
                                            <th>Sent At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $cnt = 1;
                                        foreach ($sms_history as $sms) { 
                                        ?>
                                            <tr>
                                                <td><?php echo htmlentities($cnt); ?></td>
                                                <td><?php echo htmlentities($sms->email); ?></td>
                                                <td><?php echo htmlentities($sms->phone_number); ?></td>
                                                <td><?php echo htmlentities($sms->message); ?></td>
                                                <td><?php echo htmlentities($sms->sent_at); ?></td>
                                            </tr>
                                        <?php $cnt++; } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script>
        let table = new DataTable('#smsHistory');
        $(document).ready(function() {
            setTimeout(function() {
                $('.succWrap').slideUp("slow");
            }, 3000);
        });
    </script>
</body>
</html>
<?php } ?>
