<?php
include('includes/config.php');

if (isset($_POST['searchQuery'])) {
    $searchQuery = $_POST['searchQuery'];

    // Prepare SQL to search by email, mobile, or name
    $sql = "SELECT email, mobile, name FROM users WHERE email = :query OR mobile = :query OR name LIKE :nameQuery LIMIT 1";
    $query = $dbh->prepare($sql);
    $query->bindParam(':query', $searchQuery, PDO::PARAM_STR);
    $nameQuery = "%$searchQuery%";
    $query->bindParam(':nameQuery', $nameQuery, PDO::PARAM_STR);
    $query->execute();

    // Fetch user data
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo json_encode(['success' => true, 'user' => $result]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No user found']);
    }
}
?>
