<?php
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
} else {
    if (isset($_GET['edit'])) {
        $editid = $_GET['edit'];
    }

    if (isset($_POST['submit'])) {
        $deliveryText = $_POST['bio_text']; 
        date_default_timezone_set('Asia/Dhaka');
        $updateDate = date('Y-m-d H:i:s');

        $sql = "UPDATE nid2numcopy_sub SET bio_text = :bio_text, fileup_at = :update_date, status = 2 WHERE id = :idedit";
        $query = $dbh->prepare($sql);
        $query->bindParam(':bio_text', $deliveryText, PDO::PARAM_STR); 
        $query->bindParam(':update_date', $updateDate, PDO::PARAM_STR);
        $query->bindParam(':idedit', $editid, PDO::PARAM_INT);
        $query->execute();

        $message = "Delivery Text: " . $deliveryText;

        $sqlMessage = "INSERT INTO messages (user_id, message) VALUES (:user_id, :message)";
        $messageQuery = $dbh->prepare($sqlMessage);
        $messageQuery->bindParam(':user_id', $_SESSION['user_id'], PDO::PARAM_INT); // Assuming user_id is stored in session
        $messageQuery->bindParam(':message', $message, PDO::PARAM_STR);
        $messageQuery->execute();

        $msg = "Delivery Text Updated Successfully";
        header('location:nid2num-pending.php');
        exit;
    }
?>

<!doctype html>
<html lang="en" class="no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="theme-color" content="#3e454c">
    
    <title>Update Delivery Text</title>

    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css">

    <style>
        .errorWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #dd3d36;
            color: #fff;
            box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
        }
        .succWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #5cb85c;
            color: #fff;
            box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
        }
    </style>
</head>
<body>
<?php
    $sql = "SELECT a.*, b.name as Sub_name FROM nid2numcopy_sub a JOIN users b ON Sub_by = email WHERE a.id = :editid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':editid', $editid, PDO::PARAM_INT);
    $query->execute();
    $result = $query->fetch(PDO::FETCH_OBJ);
?>
    <?php include('includes/header.php'); ?>
    <div class="ts-main-content">
        <?php include('includes/leftbar.php'); ?>
        <div class="content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="page-title">Edit User: <?php echo htmlentities($result->name); ?></h3>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">Edit Delivery Text</div>
                                    <?php if ($error) { ?>
                                        <div class="errorWrap"><strong>ERROR</strong>:<?php echo htmlentities($error); ?> </div>
                                    <?php } else if ($msg) { ?>
                                        <div class="succWrap"><strong>SUCCESS</strong>:<?php echo htmlentities($msg); ?> </div>
                                    <?php } ?>
                                    <div class="panel-body">
                                        <form method="post" class="form-horizontal" name="imgform">
                                            <div class="form-group">
                                                <label class="col-sm-2 control-label">Req Type</label>
                                                <div class="col-sm-4">
                                                    <input type="text" disabled class="form-control" required value="<?php echo htmlentities($result->sub_type); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-sm-2 control-label">Data</label>
                                                <div class="col-sm-10">
                                                    <input type="text" disabled class="form-control" required value="<?php echo htmlentities($result->nfvb); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-sm-2 control-label">Delivery Text<span style="color:red">*</span></label>
                                                <div class="col-sm-10">
                                                    <input type="text" name="bio_text" class="form-control" required placeholder="Enter delivery text">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-8 col-sm-offset-2">
                                                    <button class="btn btn-primary" name="submit" type="submit">Update Delivery Text</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            setTimeout(function () {
                $('.succWrap').slideUp("slow");
            }, 3000);
        });
    </script>
</body>
</html>
<?php } ?>