<?php  
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
} else {
    // Add a blocked word
    if (isset($_POST['add_word'])) {
        $word = $_POST['word'];

        $sql = "INSERT INTO blocked_words (word) VALUES (:word)";
        $query = $dbh->prepare($sql);
        $query->bindParam(':word', $word, PDO::PARAM_STR);
        $query->execute();
        
        $msg = "Word added successfully";
    }

    // Delete a blocked word
    if (isset($_GET['del'])) {
        $id = $_GET['del'];

        $sql = "DELETE FROM blocked_words WHERE id=:id";
        $query = $dbh->prepare($sql);
        $query->bindParam(':id', $id, PDO::PARAM_STR);
        $query->execute();

        $msg = "Word deleted successfully";
    }

    // Fetch all blocked words
    $sql = "SELECT * FROM `blocked_words`";
    $query = $dbh->prepare($sql);
    $query->execute();
    $blocked_words = $query->fetchAll(PDO::FETCH_ASSOC);

?>

<!doctype html>
<html lang="en" class="no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <title>Manage Blocked Words</title>
    <script src="https://code.jquery.com/jquery-3.6.4.slim.min.js"></script>
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .errorWrap { padding: 10px; margin: 0 0 20px 0; background: #dd3d36; color: #fff; }
        .succWrap { padding: 10px; margin: 0 0 20px 0; background: #5cb85c; color: #fff; }
    </style>
</head>

<body>
    <?php include('includes/header.php'); ?>
    <div class="ts-main-content">
        <?php include('includes/leftbar.php'); ?>
        <div class="content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <h2 class="page-title">Manage Blocked Words</h2>

                        <!-- Add Blocked Word Form -->
                        <div class="panel panel-default">
                            <div class="panel-heading">Add Blocked Word</div>
                            <div class="panel-body">
                                <?php if ($msg) { ?>
                                    <div class="succWrap" id="msgshow"><?php echo htmlentities($msg); ?> </div>
                                <?php } ?>
                                
                                <form method="POST" action="">
                                    <div class="form-group">
                                        <label for="word">Enter Blocked Word:</label>
                                        <input type="text" name="word" class="form-control" required>
                                    </div>
                                    <button type="submit" name="add_word" class="btn btn-primary">Add Word</button>
                                </form>
                            </div>
                        </div>

                        <!-- List Blocked Words -->
                        <div class="panel panel-default">
                            <div class="panel-heading">Blocked Words List</div>
                            <div class="panel-body">
                                <table id="blockedWords" class="display table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Blocked Word</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $cnt = 1;
                                        foreach ($blocked_words as $word) { 
                                        ?>
                                            <tr>
                                                <td><?php echo htmlentities($cnt); ?></td>
                                                <td><?php echo htmlentities($word['word']); ?></td>
                                                <td>
                                                    <a href="manage_words.php?del=<?php echo $word['id']; ?>" onclick="return confirm('Are you sure you want to delete this word?')" class="btn btn-danger">Delete</a>
                                                </td>
                                            </tr>
                                        <?php $cnt++; } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script>
        let table = new DataTable('#blockedWords');
        $(document).ready(function() {
            setTimeout(function() {
                $('.succWrap').slideUp("slow");
            }, 3000);
        });
    </script>
</body>
</html>
<?php } ?>
