<?php
session_start();
error_reporting(0);
include('includes/config.php');

// Include PHPMailer classes manually
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';
require '../PHPMailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
} else {
    if (isset($_POST['send_email'])) {
        $to_email = $_POST['to_email'];
        $subject = $_POST['subject'];
        $message = $_POST['message'];

        // Initialize PHPMailer
        $mail = new PHPMailer(true);

        try {
            // SMTP configuration
            $mail->isSMTP();
            $mail->Host = 'mail.bdtoolbd.xyz'; // Replace with your SMTP server
            $mail->SMTPAuth = true;
            $mail->Username = 'no-reply@bdtoolbd.xyz'; // Your SMTP username
            $mail->Password = 'Robi2034@#'; // Your SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Encryption method
            $mail->Port = 587; // SMTP port

            // Email settings
            $mail->setFrom('no-reply@bdtoolbd.xyz', 'Notification From BD TOOL BD');
            $mail->addAddress($to_email);
            $mail->Subject = $subject;

            // HTML Email content with premium design
            $htmlContent = "
                <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
                            .container { width: 100%; background-color: #f4f4f4; padding: 20px; }
                            .header { background-color: #333; padding: 10px; text-align: left; color: #fff; }
                            .header img { width: 50px; }
                            .header h1 { display: inline; margin-left: 10px; }
                            .content { background-color: #fff; padding: 20px; border-radius: 10px; }
                            .footer { background-color: #333; padding: 10px; text-align: center; color: #fff; margin-top: 20px; }
                            .footer p { margin: 0; font-size: 14px; }
                            .message { padding: 20px; background-color: #f9f9f9; border-radius: 5px; }
                        </style>
                    </head>
                    <body>
                        <div class='container'>
                            <div class='header'>
                                <img src='http://bdtoolbd.xyz/logo.png' alt='Logo' />
                                <h1>BD TOOL BD</h1>
                            </div>
                            <div class='content'>
                                <h2>$subject</h2>
                                <div class='message'>$message</div>
                            </div>
                            <div class='footer'>
                                <p>&copy; " . date('Y') . " BD TOOL BD. All rights reserved.</p>
                            </div>
                        </div>
                    </body>
                </html>
            ";

            // Set the email body
            $mail->isHTML(true);
            $mail->Body = $htmlContent;

            // Send email
            $mail->send();
            $msg = "Email sent successfully to $to_email";
        } catch (Exception $e) {
            $error = "Failed to send email. Error: " . $mail->ErrorInfo;
        }
    }
}
?>
<!doctype html>
<html lang="en" class="no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <title>Email Management</title>
    <script src="https://code.jquery.com/jquery-3.6.4.slim.min.js"></script>
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .errorWrap { padding: 10px; margin: 0 0 20px 0; background: #dd3d36; color: #fff; }
        .succWrap { padding: 10px; margin: 0 0 20px 0; background: #5cb85c; color: #fff; }
    </style>
</head>

<body>
    <?php include('includes/header.php'); ?>
    <div class="ts-main-content">
        <?php include('includes/leftbar.php'); ?>
        <div class="content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <h2 class="page-title">Send Email</h2>
                        <div class="panel panel-default">
                            <div class="panel-heading">Search Email</div>
                            <div class="panel-body">
                                <?php if ($error) { ?>
                                    <div class="errorWrap" id="msgshow"><?php echo htmlentities($error); ?> </div>
                                <?php } else if ($msg) { ?>
                                    <div class="succWrap" id="msgshow"><?php echo htmlentities($msg); ?> </div>
                                <?php } ?>
                                <!-- Email Search Box -->
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="emailSearch">Search Email:</label>
                                        <input type="text" id="emailSearch" name="emailSearch" class="form-control" placeholder="Enter email to search" required>
                                    </div>
                                    <button type="button" class="btn btn-primary" id="searchBtn">Search</button>
                                </form>
                                <br>
                                <!-- Email Sending Form -->
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="to_email">To Email:</label>
                                        <input type="email" id="to_email" name="to_email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="subject">Subject:</label>
                                        <input type="text" id="subject" name="subject" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="message">Message:</label>
                                        <textarea id="message" name="message" class="form-control" rows="5" required></textarea>
                                    </div>
                                    <button type="submit" name="send_email" class="btn btn-success">Send Email</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#searchBtn').click(function() {
                let email = $('#emailSearch').val();
                if (email) {
                    $.ajax({
                        url: 'search_email.php',
                        type: 'POST',
                        data: { emailSearch: email },
                        success: function(response) {
                            let data = JSON.parse(response);
                            if (data.success) {
                                $('#to_email').val(data.email);
                            } else {
                                alert(data.message);
                            }
                        }
                    });
                } else {
                    alert('Please enter an email to search.');
                }
            });
        });
    </script>
</body>
</html>
