<?php
session_start();
error_reporting(0);
include('includes/config.php');
include('includes/mail.php'); // Include PHPMailer function

if (isset($_SESSION['adminlogin'])) {
    header('Location: dashboard.php');
    exit();
}

if (isset($_POST['send_otp'])) {
    $email = $_POST['email'];

    // Check if email exists
    $sql = "SELECT * FROM admin WHERE email = :email";
    $query = $dbh->prepare($sql);
    $query->bindParam(':email', $email, PDO::PARAM_STR);
    $query->execute();
    $user = $query->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Generate OTP
        $otp = rand(100000, 999999);
        $_SESSION['otp'] = $otp;
        $_SESSION['email'] = $email;

        // Send OTP via email
        if (sendOTPEmail($email, $otp)) {
            echo "<script>alert('OTP sent to your email!'); document.location = 'verify.php';</script>";
        } else {
            echo "<script>alert('Failed to send OTP. Try again!');</script>";
        }
    } else {
        echo "<script>alert('Email not found!');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
</head>
<body>
    <form method="POST">
        <label>Email:</label>
        <input type="email" name="email" required>
        <button type="submit" name="send_otp">Send OTP</button>
    </form>
</body>
</html>
