<?php
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
    exit;
} else {
    if (isset($_POST['delete'])) {
        $search = $_POST['search'];

        // Find and delete users by exact name or email
        $sql = "DELETE FROM users WHERE name = :search OR email = :search";
        $query = $dbh->prepare($sql);
        $query->bindParam(':search', $search, PDO::PARAM_STR);
        $query->execute();
        
        // Delete related records from 'bkash' table
        $sqlBkash = "DELETE FROM bkash WHERE email IN (SELECT email FROM users WHERE name = :search OR email = :search)";
        $queryBkash = $dbh->prepare($sqlBkash);
        $queryBkash->bindParam(':search', $search, PDO::PARAM_STR);
        $queryBkash->execute();

        $msg = "User records deleted successfully.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Delete Users by Name or Email</title>
    <style>
        .succWrap { padding: 10px; margin-bottom: 20px; background: #5cb85c; color: white; }
        form { padding: 20px; border: 1px solid #ccc; width: 300px; margin: 30px auto; }
        input, button { padding: 8px; margin: 5px 0; width: 100%; }
    </style>
</head>
<body>
    <?php if (isset($msg)) { echo "<div class='succWrap'>" . htmlentities($msg) . "</div>"; } ?>
    <form method="post">
        <label for="search">Search by Name or Email:</label>
        <input type="text" name="search" id="search" placeholder="Enter Name or Email" required>
        <button type="submit" name="delete">Delete User</button>
    </form>
</body>
</html>
