<?php 
session_start();
error_reporting(0);
include('includes/config.php');
if (strlen($_SESSION['adminlogin']) == 0) {
	header('location:index.php');
} else {
	// Handle delete, unconfirm, confirm actions if needed

	// Fetch the list of premium account users from the `accopy_sub` table
?>

<!doctype html>
<html lang="en" class="no-js">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
	<title>Manage Premium Users</title>
	<script src="https://code.jquery.com/jquery-3.6.4.slim.min.js"></script>
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
	<script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
	<link rel="stylesheet" href="css/style.css">
	<style>
		.errorWrap { padding: 10px; margin: 0 0 20px 0; background: #dd3d36; color: #fff; }
		.succWrap { padding: 10px; margin: 0 0 20px 0; background: #5cb85c; color: #fff; }
	</style>
</head>

<body>
	<?php include('includes/header.php'); ?>
	<div class="ts-main-content">
		<?php include('includes/leftbar.php'); ?>
		<div class="content-wrapper">
			<div class="container-fluid">
				<div class="row">
					<div class="col-md-12">
						<h2 class="page-title">Manage Premium Users</h2>
						<div class="panel panel-default">
							<div class="panel-heading">List Premium Users</div>
							<div class="panel-body">
								<?php if ($error) { ?>
									<div class="errorWrap" id="msgshow"><?php echo htmlentities($error); ?> </div>
								<?php } else if ($msg) { ?>
									<div class="succWrap" id="msgshow"><?php echo htmlentities($msg); ?> </div>
								<?php } ?>
								<table id="myTable" class="display table table-striped table-bordered table-hover">
									<thead>
										<tr>
											<th>#</th>
											<th>Subscription Type</th>
											<th>Email</th>
											<th>Subscribed By</th>
											<th>Subscription Date</th>
											<th>Action</th>
										</tr>
									</thead>
									<tbody>
										<?php 
										// Fetch data from the `accopy_sub` table
										$sql = "SELECT * FROM accopy_sub";
										$query = $dbh->prepare($sql);
										$query->execute();
										$results = $query->fetchAll(PDO::FETCH_OBJ);
										$cnt = 1;
										if ($query->rowCount() > 0) {
											foreach ($results as $result) { 
										?>
											<tr>
												<td><?php echo htmlentities($cnt); ?></td>
												<td><?php echo htmlentities($result->sub_type); ?></td>
												<td><?php echo htmlentities($result->email); ?></td>
												<td><?php echo htmlentities($result->Sub_by); ?></td>
												<td><?php echo htmlentities($result->date_flt); ?></td>
												<td>
													<!-- Add any relevant actions here -->
													<a href="edit-premium-user.php?edit=<?php echo $result->id; ?>"><i class="fa fa-pencil"></i></a>
													<a href="premium-userlist.php?del=<?php echo $result->id; ?>&email=<?php echo htmlentities($result->email); ?>"><i class="fa fa-trash" style="color:red"></i></a>
												</td>
											</tr>
										<?php $cnt++; }
										} ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script>
		let table = new DataTable('#myTable');
		$(document).ready(function() {
			setTimeout(function() {
				$('.succWrap').slideUp("slow");
			}, 3000);
		});
	</script>
</body>
</html>
<?php } ?>
